<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoleUsabilityViolationException StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RoleUsabilityViolationException
 * @subpackage Structs
 */
class RoleUsabilityViolationException extends MsolAdministrationException
{
    /**
     * The RoleId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoleId;
    /**
     * Constructor method for RoleUsabilityViolationException
     * @uses RoleUsabilityViolationException::setRoleId()
     * @param string $roleId
     */
    public function __construct($roleId = null)
    {
        $this
            ->setRoleId($roleId);
    }
    /**
     * Get RoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoleId()
    {
        return isset($this->RoleId) ? $this->RoleId : null;
    }
    /**
     * Set RoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roleId
     * @return \StructType\RoleUsabilityViolationException
     */
    public function setRoleId($roleId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($roleId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $roleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($roleId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($roleId) && !is_string($roleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roleId)), __LINE__);
        }
        if (is_null($roleId) || (is_array($roleId) && empty($roleId))) {
            unset($this->RoleId);
        } else {
            $this->RoleId = $roleId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoleUsabilityViolationException
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
