<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoleScopedMember StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RoleScopedMember
 * @subpackage Structs
 */
class RoleScopedMember extends AbstractStructBase
{
    /**
     * The AdministrativeUnitObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AdministrativeUnitObjectId;
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The ObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObjectId;
    /**
     * The RoleMemberType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RoleMemberType;
    /**
     * The UserPrincipalName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserPrincipalName;
    /**
     * Constructor method for RoleScopedMember
     * @uses RoleScopedMember::setAdministrativeUnitObjectId()
     * @uses RoleScopedMember::setDisplayName()
     * @uses RoleScopedMember::setObjectId()
     * @uses RoleScopedMember::setRoleMemberType()
     * @uses RoleScopedMember::setUserPrincipalName()
     * @param string $administrativeUnitObjectId
     * @param string $displayName
     * @param string $objectId
     * @param string $roleMemberType
     * @param string $userPrincipalName
     */
    public function __construct($administrativeUnitObjectId = null, $displayName = null, $objectId = null, $roleMemberType = null, $userPrincipalName = null)
    {
        $this
            ->setAdministrativeUnitObjectId($administrativeUnitObjectId)
            ->setDisplayName($displayName)
            ->setObjectId($objectId)
            ->setRoleMemberType($roleMemberType)
            ->setUserPrincipalName($userPrincipalName);
    }
    /**
     * Get AdministrativeUnitObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdministrativeUnitObjectId()
    {
        return isset($this->AdministrativeUnitObjectId) ? $this->AdministrativeUnitObjectId : null;
    }
    /**
     * Set AdministrativeUnitObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $administrativeUnitObjectId
     * @return \StructType\RoleScopedMember
     */
    public function setAdministrativeUnitObjectId($administrativeUnitObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($administrativeUnitObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $administrativeUnitObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($administrativeUnitObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($administrativeUnitObjectId) && !is_string($administrativeUnitObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($administrativeUnitObjectId)), __LINE__);
        }
        if (is_null($administrativeUnitObjectId) || (is_array($administrativeUnitObjectId) && empty($administrativeUnitObjectId))) {
            unset($this->AdministrativeUnitObjectId);
        } else {
            $this->AdministrativeUnitObjectId = $administrativeUnitObjectId;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \StructType\RoleScopedMember
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get ObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObjectId()
    {
        return isset($this->ObjectId) ? $this->ObjectId : null;
    }
    /**
     * Set ObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $objectId
     * @return \StructType\RoleScopedMember
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($objectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($objectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectId)), __LINE__);
        }
        if (is_null($objectId) || (is_array($objectId) && empty($objectId))) {
            unset($this->ObjectId);
        } else {
            $this->ObjectId = $objectId;
        }
        return $this;
    }
    /**
     * Get RoleMemberType value
     * @return string|null
     */
    public function getRoleMemberType()
    {
        return $this->RoleMemberType;
    }
    /**
     * Set RoleMemberType value
     * @uses \EnumType\RoleMemberType::valueIsValid()
     * @uses \EnumType\RoleMemberType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roleMemberType
     * @return \StructType\RoleScopedMember
     */
    public function setRoleMemberType($roleMemberType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoleMemberType::valueIsValid($roleMemberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $roleMemberType, implode(', ', \EnumType\RoleMemberType::getValidValues())), __LINE__);
        }
        $this->RoleMemberType = $roleMemberType;
        return $this;
    }
    /**
     * Get UserPrincipalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserPrincipalName()
    {
        return isset($this->UserPrincipalName) ? $this->UserPrincipalName : null;
    }
    /**
     * Set UserPrincipalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userPrincipalName
     * @return \StructType\RoleScopedMember
     */
    public function setUserPrincipalName($userPrincipalName = null)
    {
        // validation for constraint: string
        if (!is_null($userPrincipalName) && !is_string($userPrincipalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userPrincipalName)), __LINE__);
        }
        if (is_null($userPrincipalName) || (is_array($userPrincipalName) && empty($userPrincipalName))) {
            unset($this->UserPrincipalName);
        } else {
            $this->UserPrincipalName = $userPrincipalName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoleScopedMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
