<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Request
 * @subpackage Structs
 */
class Request extends AbstractStructBase
{
    /**
     * The BecVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BecVersion;
    /**
     * The TenantId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TenantId;
    /**
     * The VerifiedDomain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VerifiedDomain;
    /**
     * Constructor method for Request
     * @uses Request::setBecVersion()
     * @uses Request::setTenantId()
     * @uses Request::setVerifiedDomain()
     * @param string $becVersion
     * @param string $tenantId
     * @param string $verifiedDomain
     */
    public function __construct($becVersion = null, $tenantId = null, $verifiedDomain = null)
    {
        $this
            ->setBecVersion($becVersion)
            ->setTenantId($tenantId)
            ->setVerifiedDomain($verifiedDomain);
    }
    /**
     * Get BecVersion value
     * @return string|null
     */
    public function getBecVersion()
    {
        return $this->BecVersion;
    }
    /**
     * Set BecVersion value
     * @uses \EnumType\Version::valueIsValid()
     * @uses \EnumType\Version::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $becVersion
     * @return \StructType\Request
     */
    public function setBecVersion($becVersion = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Version::valueIsValid($becVersion)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $becVersion, implode(', ', \EnumType\Version::getValidValues())), __LINE__);
        }
        $this->BecVersion = $becVersion;
        return $this;
    }
    /**
     * Get TenantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTenantId()
    {
        return isset($this->TenantId) ? $this->TenantId : null;
    }
    /**
     * Set TenantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tenantId
     * @return \StructType\Request
     */
    public function setTenantId($tenantId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($tenantId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $tenantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($tenantId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tenantId) && !is_string($tenantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tenantId)), __LINE__);
        }
        if (is_null($tenantId) || (is_array($tenantId) && empty($tenantId))) {
            unset($this->TenantId);
        } else {
            $this->TenantId = $tenantId;
        }
        return $this;
    }
    /**
     * Get VerifiedDomain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVerifiedDomain()
    {
        return isset($this->VerifiedDomain) ? $this->VerifiedDomain : null;
    }
    /**
     * Set VerifiedDomain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $verifiedDomain
     * @return \StructType\Request
     */
    public function setVerifiedDomain($verifiedDomain = null)
    {
        // validation for constraint: string
        if (!is_null($verifiedDomain) && !is_string($verifiedDomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($verifiedDomain)), __LINE__);
        }
        if (is_null($verifiedDomain) || (is_array($verifiedDomain) && empty($verifiedDomain))) {
            unset($this->VerifiedDomain);
        } else {
            $this->VerifiedDomain = $verifiedDomain;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Request
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
