<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedirectUri StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RedirectUri
 * @subpackage Structs
 */
class RedirectUri extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address;
    /**
     * The AddressType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AddressType;
    /**
     * Constructor method for RedirectUri
     * @uses RedirectUri::setAddress()
     * @uses RedirectUri::setAddressType()
     * @param string $address
     * @param string $addressType
     */
    public function __construct($address = null, $addressType = null)
    {
        $this
            ->setAddress($address)
            ->setAddressType($addressType);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address
     * @return \StructType\RedirectUri
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get AddressType value
     * @return string|null
     */
    public function getAddressType()
    {
        return $this->AddressType;
    }
    /**
     * Set AddressType value
     * @uses \EnumType\AddressType::valueIsValid()
     * @uses \EnumType\AddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addressType
     * @return \StructType\RedirectUri
     */
    public function setAddressType($addressType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressType::valueIsValid($addressType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $addressType, implode(', ', \EnumType\AddressType::getValidValues())), __LINE__);
        }
        $this->AddressType = $addressType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RedirectUri
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
