<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemCountValidationException StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ItemCountValidationException
 * @subpackage Structs
 */
class ItemCountValidationException extends PropertyValidationException
{
    /**
     * The MaxCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxCount;
    /**
     * The MinCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinCount;
    /**
     * Constructor method for ItemCountValidationException
     * @uses ItemCountValidationException::setMaxCount()
     * @uses ItemCountValidationException::setMinCount()
     * @param int $maxCount
     * @param int $minCount
     */
    public function __construct($maxCount = null, $minCount = null)
    {
        $this
            ->setMaxCount($maxCount)
            ->setMinCount($minCount);
    }
    /**
     * Get MaxCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxCount()
    {
        return isset($this->MaxCount) ? $this->MaxCount : null;
    }
    /**
     * Set MaxCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxCount
     * @return \StructType\ItemCountValidationException
     */
    public function setMaxCount($maxCount = null)
    {
        // validation for constraint: int
        if (!is_null($maxCount) && !is_numeric($maxCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxCount)), __LINE__);
        }
        if (is_null($maxCount) || (is_array($maxCount) && empty($maxCount))) {
            unset($this->MaxCount);
        } else {
            $this->MaxCount = $maxCount;
        }
        return $this;
    }
    /**
     * Get MinCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinCount()
    {
        return isset($this->MinCount) ? $this->MinCount : null;
    }
    /**
     * Set MinCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minCount
     * @return \StructType\ItemCountValidationException
     */
    public function setMinCount($minCount = null)
    {
        // validation for constraint: int
        if (!is_null($minCount) && !is_numeric($minCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minCount)), __LINE__);
        }
        if (is_null($minCount) || (is_array($minCount) && empty($minCount))) {
            unset($this->MinCount);
        } else {
            $this->MinCount = $minCount;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemCountValidationException
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
