<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupMember StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GroupMember
 * @subpackage Structs
 */
class GroupMember extends AbstractStructBase
{
    /**
     * The CommonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommonName;
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailAddress;
    /**
     * The GroupMemberType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GroupMemberType;
    /**
     * The IsLicensed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsLicensed;
    /**
     * The LastDirSyncTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastDirSyncTime;
    /**
     * The ObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObjectId;
    /**
     * The OverallProvisioningStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OverallProvisioningStatus;
    /**
     * The ValidationStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidationStatus;
    /**
     * Constructor method for GroupMember
     * @uses GroupMember::setCommonName()
     * @uses GroupMember::setDisplayName()
     * @uses GroupMember::setEmailAddress()
     * @uses GroupMember::setGroupMemberType()
     * @uses GroupMember::setIsLicensed()
     * @uses GroupMember::setLastDirSyncTime()
     * @uses GroupMember::setObjectId()
     * @uses GroupMember::setOverallProvisioningStatus()
     * @uses GroupMember::setValidationStatus()
     * @param string $commonName
     * @param string $displayName
     * @param string $emailAddress
     * @param string $groupMemberType
     * @param bool $isLicensed
     * @param string $lastDirSyncTime
     * @param string $objectId
     * @param string $overallProvisioningStatus
     * @param string $validationStatus
     */
    public function __construct($commonName = null, $displayName = null, $emailAddress = null, $groupMemberType = null, $isLicensed = null, $lastDirSyncTime = null, $objectId = null, $overallProvisioningStatus = null, $validationStatus = null)
    {
        $this
            ->setCommonName($commonName)
            ->setDisplayName($displayName)
            ->setEmailAddress($emailAddress)
            ->setGroupMemberType($groupMemberType)
            ->setIsLicensed($isLicensed)
            ->setLastDirSyncTime($lastDirSyncTime)
            ->setObjectId($objectId)
            ->setOverallProvisioningStatus($overallProvisioningStatus)
            ->setValidationStatus($validationStatus);
    }
    /**
     * Get CommonName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommonName()
    {
        return isset($this->CommonName) ? $this->CommonName : null;
    }
    /**
     * Set CommonName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commonName
     * @return \StructType\GroupMember
     */
    public function setCommonName($commonName = null)
    {
        // validation for constraint: string
        if (!is_null($commonName) && !is_string($commonName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commonName)), __LINE__);
        }
        if (is_null($commonName) || (is_array($commonName) && empty($commonName))) {
            unset($this->CommonName);
        } else {
            $this->CommonName = $commonName;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \StructType\GroupMember
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get EmailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAddress()
    {
        return isset($this->EmailAddress) ? $this->EmailAddress : null;
    }
    /**
     * Set EmailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAddress
     * @return \StructType\GroupMember
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        if (is_null($emailAddress) || (is_array($emailAddress) && empty($emailAddress))) {
            unset($this->EmailAddress);
        } else {
            $this->EmailAddress = $emailAddress;
        }
        return $this;
    }
    /**
     * Get GroupMemberType value
     * @return string|null
     */
    public function getGroupMemberType()
    {
        return $this->GroupMemberType;
    }
    /**
     * Set GroupMemberType value
     * @uses \EnumType\GroupMemberType::valueIsValid()
     * @uses \EnumType\GroupMemberType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $groupMemberType
     * @return \StructType\GroupMember
     */
    public function setGroupMemberType($groupMemberType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GroupMemberType::valueIsValid($groupMemberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $groupMemberType, implode(', ', \EnumType\GroupMemberType::getValidValues())), __LINE__);
        }
        $this->GroupMemberType = $groupMemberType;
        return $this;
    }
    /**
     * Get IsLicensed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsLicensed()
    {
        return isset($this->IsLicensed) ? $this->IsLicensed : null;
    }
    /**
     * Set IsLicensed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isLicensed
     * @return \StructType\GroupMember
     */
    public function setIsLicensed($isLicensed = null)
    {
        if (is_null($isLicensed) || (is_array($isLicensed) && empty($isLicensed))) {
            unset($this->IsLicensed);
        } else {
            $this->IsLicensed = $isLicensed;
        }
        return $this;
    }
    /**
     * Get LastDirSyncTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastDirSyncTime()
    {
        return isset($this->LastDirSyncTime) ? $this->LastDirSyncTime : null;
    }
    /**
     * Set LastDirSyncTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastDirSyncTime
     * @return \StructType\GroupMember
     */
    public function setLastDirSyncTime($lastDirSyncTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastDirSyncTime) && !is_string($lastDirSyncTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastDirSyncTime)), __LINE__);
        }
        if (is_null($lastDirSyncTime) || (is_array($lastDirSyncTime) && empty($lastDirSyncTime))) {
            unset($this->LastDirSyncTime);
        } else {
            $this->LastDirSyncTime = $lastDirSyncTime;
        }
        return $this;
    }
    /**
     * Get ObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObjectId()
    {
        return isset($this->ObjectId) ? $this->ObjectId : null;
    }
    /**
     * Set ObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $objectId
     * @return \StructType\GroupMember
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($objectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($objectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectId)), __LINE__);
        }
        if (is_null($objectId) || (is_array($objectId) && empty($objectId))) {
            unset($this->ObjectId);
        } else {
            $this->ObjectId = $objectId;
        }
        return $this;
    }
    /**
     * Get OverallProvisioningStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOverallProvisioningStatus()
    {
        return isset($this->OverallProvisioningStatus) ? $this->OverallProvisioningStatus : null;
    }
    /**
     * Set OverallProvisioningStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ProvisioningStatus::valueIsValid()
     * @uses \EnumType\ProvisioningStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $overallProvisioningStatus
     * @return \StructType\GroupMember
     */
    public function setOverallProvisioningStatus($overallProvisioningStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProvisioningStatus::valueIsValid($overallProvisioningStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $overallProvisioningStatus, implode(', ', \EnumType\ProvisioningStatus::getValidValues())), __LINE__);
        }
        if (is_null($overallProvisioningStatus) || (is_array($overallProvisioningStatus) && empty($overallProvisioningStatus))) {
            unset($this->OverallProvisioningStatus);
        } else {
            $this->OverallProvisioningStatus = $overallProvisioningStatus;
        }
        return $this;
    }
    /**
     * Get ValidationStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidationStatus()
    {
        return isset($this->ValidationStatus) ? $this->ValidationStatus : null;
    }
    /**
     * Set ValidationStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ValidationStatus::valueIsValid()
     * @uses \EnumType\ValidationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $validationStatus
     * @return \StructType\GroupMember
     */
    public function setValidationStatus($validationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ValidationStatus::valueIsValid($validationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $validationStatus, implode(', ', \EnumType\ValidationStatus::getValidValues())), __LINE__);
        }
        if (is_null($validationStatus) || (is_array($validationStatus) && empty($validationStatus))) {
            unset($this->ValidationStatus);
        } else {
            $this->ValidationStatus = $validationStatus;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
