<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUserByLiveIdRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetUserByLiveIdRequest
 * @subpackage Structs
 */
class GetUserByLiveIdRequest extends Request
{
    /**
     * The LiveId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LiveId;
    /**
     * Constructor method for GetUserByLiveIdRequest
     * @uses GetUserByLiveIdRequest::setLiveId()
     * @param string $liveId
     */
    public function __construct($liveId = null)
    {
        $this
            ->setLiveId($liveId);
    }
    /**
     * Get LiveId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLiveId()
    {
        return isset($this->LiveId) ? $this->LiveId : null;
    }
    /**
     * Set LiveId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $liveId
     * @return \StructType\GetUserByLiveIdRequest
     */
    public function setLiveId($liveId = null)
    {
        // validation for constraint: string
        if (!is_null($liveId) && !is_string($liveId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($liveId)), __LINE__);
        }
        if (is_null($liveId) || (is_array($liveId) && empty($liveId))) {
            unset($this->LiveId);
        } else {
            $this->LiveId = $liveId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetUserByLiveIdRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
