<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetServicePrincipalByAppPrincipalIdRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetServicePrincipalByAppPrincipalIdRequest
 * @subpackage Structs
 */
class GetServicePrincipalByAppPrincipalIdRequest extends Request
{
    /**
     * The AppPrincipalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppPrincipalId;
    /**
     * Constructor method for GetServicePrincipalByAppPrincipalIdRequest
     * @uses GetServicePrincipalByAppPrincipalIdRequest::setAppPrincipalId()
     * @param string $appPrincipalId
     */
    public function __construct($appPrincipalId = null)
    {
        $this
            ->setAppPrincipalId($appPrincipalId);
    }
    /**
     * Get AppPrincipalId value
     * @return string|null
     */
    public function getAppPrincipalId()
    {
        return $this->AppPrincipalId;
    }
    /**
     * Set AppPrincipalId value
     * @param string $appPrincipalId
     * @return \StructType\GetServicePrincipalByAppPrincipalIdRequest
     */
    public function setAppPrincipalId($appPrincipalId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($appPrincipalId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $appPrincipalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($appPrincipalId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($appPrincipalId) && !is_string($appPrincipalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appPrincipalId)), __LINE__);
        }
        $this->AppPrincipalId = $appPrincipalId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetServicePrincipalByAppPrincipalIdRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
