<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContractVersionHeader StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ContractVersionHeader
 * @subpackage Structs
 */
class ContractVersionHeader extends AbstractStructBase
{
    /**
     * The BecVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BecVersion;
    /**
     * Constructor method for ContractVersionHeader
     * @uses ContractVersionHeader::setBecVersion()
     * @param string $becVersion
     */
    public function __construct($becVersion = null)
    {
        $this
            ->setBecVersion($becVersion);
    }
    /**
     * Get BecVersion value
     * @return string|null
     */
    public function getBecVersion()
    {
        return $this->BecVersion;
    }
    /**
     * Set BecVersion value
     * @uses \EnumType\Version::valueIsValid()
     * @uses \EnumType\Version::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $becVersion
     * @return \StructType\ContractVersionHeader
     */
    public function setBecVersion($becVersion = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Version::valueIsValid($becVersion)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $becVersion, implode(', ', \EnumType\Version::getValidValues())), __LINE__);
        }
        $this->BecVersion = $becVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContractVersionHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
