<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlternativeSecurityId StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AlternativeSecurityId
 * @subpackage Structs
 */
class AlternativeSecurityId extends AbstractStructBase
{
    /**
     * The IdentityProvider
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdentityProvider;
    /**
     * The Key
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Type;
    /**
     * Constructor method for AlternativeSecurityId
     * @uses AlternativeSecurityId::setIdentityProvider()
     * @uses AlternativeSecurityId::setKey()
     * @uses AlternativeSecurityId::setType()
     * @param string $identityProvider
     * @param string $key
     * @param int $type
     */
    public function __construct($identityProvider = null, $key = null, $type = null)
    {
        $this
            ->setIdentityProvider($identityProvider)
            ->setKey($key)
            ->setType($type);
    }
    /**
     * Get IdentityProvider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentityProvider()
    {
        return isset($this->IdentityProvider) ? $this->IdentityProvider : null;
    }
    /**
     * Set IdentityProvider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identityProvider
     * @return \StructType\AlternativeSecurityId
     */
    public function setIdentityProvider($identityProvider = null)
    {
        // validation for constraint: string
        if (!is_null($identityProvider) && !is_string($identityProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identityProvider)), __LINE__);
        }
        if (is_null($identityProvider) || (is_array($identityProvider) && empty($identityProvider))) {
            unset($this->IdentityProvider);
        } else {
            $this->IdentityProvider = $identityProvider;
        }
        return $this;
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\AlternativeSecurityId
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return int|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param int $type
     * @return \StructType\AlternativeSecurityId
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !is_numeric($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AlternativeSecurityId
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
