<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddRoleMembersByRoleNameRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AddRoleMembersByRoleNameRequest
 * @subpackage Structs
 */
class AddRoleMembersByRoleNameRequest extends Request
{
    /**
     * The RoleMembers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRoleMember
     */
    public $RoleMembers;
    /**
     * The RoleName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoleName;
    /**
     * Constructor method for AddRoleMembersByRoleNameRequest
     * @uses AddRoleMembersByRoleNameRequest::setRoleMembers()
     * @uses AddRoleMembersByRoleNameRequest::setRoleName()
     * @param \ArrayType\ArrayOfRoleMember $roleMembers
     * @param string $roleName
     */
    public function __construct(\ArrayType\ArrayOfRoleMember $roleMembers = null, $roleName = null)
    {
        $this
            ->setRoleMembers($roleMembers)
            ->setRoleName($roleName);
    }
    /**
     * Get RoleMembers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRoleMember|null
     */
    public function getRoleMembers()
    {
        return isset($this->RoleMembers) ? $this->RoleMembers : null;
    }
    /**
     * Set RoleMembers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRoleMember $roleMembers
     * @return \StructType\AddRoleMembersByRoleNameRequest
     */
    public function setRoleMembers(\ArrayType\ArrayOfRoleMember $roleMembers = null)
    {
        if (is_null($roleMembers) || (is_array($roleMembers) && empty($roleMembers))) {
            unset($this->RoleMembers);
        } else {
            $this->RoleMembers = $roleMembers;
        }
        return $this;
    }
    /**
     * Get RoleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoleName()
    {
        return isset($this->RoleName) ? $this->RoleName : null;
    }
    /**
     * Set RoleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roleName
     * @return \StructType\AddRoleMembersByRoleNameRequest
     */
    public function setRoleName($roleName = null)
    {
        // validation for constraint: string
        if (!is_null($roleName) && !is_string($roleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roleName)), __LINE__);
        }
        if (is_null($roleName) || (is_array($roleName) && empty($roleName))) {
            unset($this->RoleName);
        } else {
            $this->RoleName = $roleName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddRoleMembersByRoleNameRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
