<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccidentalDeletionInformation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AccidentalDeletionInformation
 * @subpackage Structs
 */
class AccidentalDeletionInformation extends AbstractStructBase
{
    /**
     * The AccidentalDeletionThreshold
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AccidentalDeletionThreshold;
    /**
     * The DeletionPreventionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeletionPreventionType;
    /**
     * Constructor method for AccidentalDeletionInformation
     * @uses AccidentalDeletionInformation::setAccidentalDeletionThreshold()
     * @uses AccidentalDeletionInformation::setDeletionPreventionType()
     * @param int $accidentalDeletionThreshold
     * @param string $deletionPreventionType
     */
    public function __construct($accidentalDeletionThreshold = null, $deletionPreventionType = null)
    {
        $this
            ->setAccidentalDeletionThreshold($accidentalDeletionThreshold)
            ->setDeletionPreventionType($deletionPreventionType);
    }
    /**
     * Get AccidentalDeletionThreshold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAccidentalDeletionThreshold()
    {
        return isset($this->AccidentalDeletionThreshold) ? $this->AccidentalDeletionThreshold : null;
    }
    /**
     * Set AccidentalDeletionThreshold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $accidentalDeletionThreshold
     * @return \StructType\AccidentalDeletionInformation
     */
    public function setAccidentalDeletionThreshold($accidentalDeletionThreshold = null)
    {
        // validation for constraint: int
        if (!is_null($accidentalDeletionThreshold) && !is_numeric($accidentalDeletionThreshold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accidentalDeletionThreshold)), __LINE__);
        }
        if (is_null($accidentalDeletionThreshold) || (is_array($accidentalDeletionThreshold) && empty($accidentalDeletionThreshold))) {
            unset($this->AccidentalDeletionThreshold);
        } else {
            $this->AccidentalDeletionThreshold = $accidentalDeletionThreshold;
        }
        return $this;
    }
    /**
     * Get DeletionPreventionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeletionPreventionType()
    {
        return isset($this->DeletionPreventionType) ? $this->DeletionPreventionType : null;
    }
    /**
     * Set DeletionPreventionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DirSyncDeletionPreventionType::valueIsValid()
     * @uses \EnumType\DirSyncDeletionPreventionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deletionPreventionType
     * @return \StructType\AccidentalDeletionInformation
     */
    public function setDeletionPreventionType($deletionPreventionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DirSyncDeletionPreventionType::valueIsValid($deletionPreventionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deletionPreventionType, implode(', ', \EnumType\DirSyncDeletionPreventionType::getValidValues())), __LINE__);
        }
        if (is_null($deletionPreventionType) || (is_array($deletionPreventionType) && empty($deletionPreventionType))) {
            unset($this->DeletionPreventionType);
        } else {
            $this->DeletionPreventionType = $deletionPreventionType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccidentalDeletionInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
