<?php

namespace EnumType;

/**
 * This class stands for PartnerContractSearchKey EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PartnerContractSearchKey
 * @subpackage Enumerations
 */
class PartnerContractSearchKey
{
    /**
     * Constant for value 'DisplayName'
     * @return string 'DisplayName'
     */
    const VALUE_DISPLAY_NAME = 'DisplayName';
    /**
     * Constant for value 'DefaultDomainName'
     * @return string 'DefaultDomainName'
     */
    const VALUE_DEFAULT_DOMAIN_NAME = 'DefaultDomainName';
    /**
     * Constant for value 'CompanyDisplayName'
     * @return string 'CompanyDisplayName'
     */
    const VALUE_COMPANY_DISPLAY_NAME = 'CompanyDisplayName';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DISPLAY_NAME
     * @uses self::VALUE_DEFAULT_DOMAIN_NAME
     * @uses self::VALUE_COMPANY_DISPLAY_NAME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DISPLAY_NAME,
            self::VALUE_DEFAULT_DOMAIN_NAME,
            self::VALUE_COMPANY_DISPLAY_NAME,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
