<?php

namespace EnumType;

/**
 * This class stands for GroupLicenseProcessingStatus EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GroupLicenseProcessingStatus
 * @subpackage Enumerations
 */
class GroupLicenseProcessingStatus
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Ready'
     * @return string 'Ready'
     */
    const VALUE_READY = 'Ready';
    /**
     * Constant for value 'Queued'
     * @return string 'Queued'
     */
    const VALUE_QUEUED = 'Queued';
    /**
     * Constant for value 'Processing'
     * @return string 'Processing'
     */
    const VALUE_PROCESSING = 'Processing';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_READY
     * @uses self::VALUE_QUEUED
     * @uses self::VALUE_PROCESSING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_READY,
            self::VALUE_QUEUED,
            self::VALUE_PROCESSING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
