<?php

namespace EnumType;

/**
 * This class stands for DomainStatus EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DomainStatus
 * @subpackage Enumerations
 */
class DomainStatus
{
    /**
     * Constant for value 'Unverified'
     * @return string 'Unverified'
     */
    const VALUE_UNVERIFIED = 'Unverified';
    /**
     * Constant for value 'Verified'
     * @return string 'Verified'
     */
    const VALUE_VERIFIED = 'Verified';
    /**
     * Constant for value 'PendingDeletion'
     * @return string 'PendingDeletion'
     */
    const VALUE_PENDING_DELETION = 'PendingDeletion';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNVERIFIED
     * @uses self::VALUE_VERIFIED
     * @uses self::VALUE_PENDING_DELETION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNVERIFIED,
            self::VALUE_VERIFIED,
            self::VALUE_PENDING_DELETION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
