<?php

namespace EnumType;

/**
 * This class stands for ContractType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ContractType
 * @subpackage Enumerations
 */
class ContractType
{
    /**
     * Constant for value 'MicrosoftSupportContract'
     * @return string 'MicrosoftSupportContract'
     */
    const VALUE_MICROSOFT_SUPPORT_CONTRACT = 'MicrosoftSupportContract';
    /**
     * Constant for value 'SyndicationSupportContract'
     * @return string 'SyndicationSupportContract'
     */
    const VALUE_SYNDICATION_SUPPORT_CONTRACT = 'SyndicationSupportContract';
    /**
     * Constant for value 'SupportPartnerContract'
     * @return string 'SupportPartnerContract'
     */
    const VALUE_SUPPORT_PARTNER_CONTRACT = 'SupportPartnerContract';
    /**
     * Constant for value 'ResellerPartnerContract'
     * @return string 'ResellerPartnerContract'
     */
    const VALUE_RESELLER_PARTNER_CONTRACT = 'ResellerPartnerContract';
    /**
     * Constant for value 'DistributionContract'
     * @return string 'DistributionContract'
     */
    const VALUE_DISTRIBUTION_CONTRACT = 'DistributionContract';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MICROSOFT_SUPPORT_CONTRACT
     * @uses self::VALUE_SYNDICATION_SUPPORT_CONTRACT
     * @uses self::VALUE_SUPPORT_PARTNER_CONTRACT
     * @uses self::VALUE_RESELLER_PARTNER_CONTRACT
     * @uses self::VALUE_DISTRIBUTION_CONTRACT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MICROSOFT_SUPPORT_CONTRACT,
            self::VALUE_SYNDICATION_SUPPORT_CONTRACT,
            self::VALUE_SUPPORT_PARTNER_CONTRACT,
            self::VALUE_RESELLER_PARTNER_CONTRACT,
            self::VALUE_DISTRIBUTION_CONTRACT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
