<?php

namespace EnumType;

/**
 * This class stands for AddressType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AddressType
 * @subpackage Enumerations
 */
class AddressType
{
    /**
     * Constant for value 'Reply'
     * @return string 'Reply'
     */
    const VALUE_REPLY = 'Reply';
    /**
     * Constant for value 'Realm'
     * @return string 'Realm'
     */
    const VALUE_REALM = 'Realm';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'SamlMetadata'
     * @return string 'SamlMetadata'
     */
    const VALUE_SAML_METADATA = 'SamlMetadata';
    /**
     * Constant for value 'SamlLogout'
     * @return string 'SamlLogout'
     */
    const VALUE_SAML_LOGOUT = 'SamlLogout';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REPLY
     * @uses self::VALUE_REALM
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_SAML_METADATA
     * @uses self::VALUE_SAML_LOGOUT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REPLY,
            self::VALUE_REALM,
            self::VALUE_ERROR,
            self::VALUE_OTHER,
            self::VALUE_SAML_METADATA,
            self::VALUE_SAML_LOGOUT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
