<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAlternativeSecurityId ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAlternativeSecurityId
 * @subpackage Arrays
 */
class ArrayOfAlternativeSecurityId extends AbstractStructArrayBase
{
    /**
     * The AlternativeSecurityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AlternativeSecurityId[]
     */
    public $AlternativeSecurityId;
    /**
     * Constructor method for ArrayOfAlternativeSecurityId
     * @uses ArrayOfAlternativeSecurityId::setAlternativeSecurityId()
     * @param \StructType\AlternativeSecurityId[] $alternativeSecurityId
     */
    public function __construct(array $alternativeSecurityId = array())
    {
        $this
            ->setAlternativeSecurityId($alternativeSecurityId);
    }
    /**
     * Get AlternativeSecurityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AlternativeSecurityId[]|null
     */
    public function getAlternativeSecurityId()
    {
        return isset($this->AlternativeSecurityId) ? $this->AlternativeSecurityId : null;
    }
    /**
     * Set AlternativeSecurityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AlternativeSecurityId[] $alternativeSecurityId
     * @return \ArrayType\ArrayOfAlternativeSecurityId
     */
    public function setAlternativeSecurityId(array $alternativeSecurityId = array())
    {
        foreach ($alternativeSecurityId as $arrayOfAlternativeSecurityIdAlternativeSecurityIdItem) {
            // validation for constraint: itemType
            if (!$arrayOfAlternativeSecurityIdAlternativeSecurityIdItem instanceof \StructType\AlternativeSecurityId) {
                throw new \InvalidArgumentException(sprintf('The AlternativeSecurityId property can only contain items of \StructType\AlternativeSecurityId, "%s" given', is_object($arrayOfAlternativeSecurityIdAlternativeSecurityIdItem) ? get_class($arrayOfAlternativeSecurityIdAlternativeSecurityIdItem) : gettype($arrayOfAlternativeSecurityIdAlternativeSecurityIdItem)), __LINE__);
            }
        }
        if (is_null($alternativeSecurityId) || (is_array($alternativeSecurityId) && empty($alternativeSecurityId))) {
            unset($this->AlternativeSecurityId);
        } else {
            $this->AlternativeSecurityId = $alternativeSecurityId;
        }
        return $this;
    }
    /**
     * Add item to AlternativeSecurityId value
     * @throws \InvalidArgumentException
     * @param \StructType\AlternativeSecurityId $item
     * @return \ArrayType\ArrayOfAlternativeSecurityId
     */
    public function addToAlternativeSecurityId(\StructType\AlternativeSecurityId $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AlternativeSecurityId) {
            throw new \InvalidArgumentException(sprintf('The AlternativeSecurityId property can only contain items of \StructType\AlternativeSecurityId, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AlternativeSecurityId[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AlternativeSecurityId|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AlternativeSecurityId|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AlternativeSecurityId|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AlternativeSecurityId|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AlternativeSecurityId|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AlternativeSecurityId
     */
    public function getAttributeName()
    {
        return 'AlternativeSecurityId';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAlternativeSecurityId
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
