<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for User StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:User
 * @subpackage Structs
 */
class User extends AbstractStructBase
{
    /**
     * The AlternateEmailAddresses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $AlternateEmailAddresses;
    /**
     * The AlternateMobilePhones
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $AlternateMobilePhones;
    /**
     * The AlternativeSecurityIds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAlternativeSecurityId
     */
    public $AlternativeSecurityIds;
    /**
     * The BlockCredential
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BlockCredential;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The CloudExchangeRecipientDisplayType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CloudExchangeRecipientDisplayType;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The Department
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Department;
    /**
     * The DirSyncProvisioningErrors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDirSyncProvisioningError
     */
    public $DirSyncProvisioningErrors;
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfValidationError
     */
    public $Errors;
    /**
     * The Fax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fax;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The ImmutableId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImmutableId;
    /**
     * The IndirectLicenseErrors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfIndirectLicenseError
     */
    public $IndirectLicenseErrors;
    /**
     * The IsBlackberryUser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsBlackberryUser;
    /**
     * The IsLicensed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsLicensed;
    /**
     * The LastDirSyncTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastDirSyncTime;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The LastPasswordChangeTimestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastPasswordChangeTimestamp;
    /**
     * The LicenseAssignmentDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLicenseAssignmentDetail
     */
    public $LicenseAssignmentDetails;
    /**
     * The LicenseReconciliationNeeded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $LicenseReconciliationNeeded;
    /**
     * The Licenses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfUserLicense
     */
    public $Licenses;
    /**
     * The LiveId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LiveId;
    /**
     * The MSExchRecipientTypeDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MSExchRecipientTypeDetails;
    /**
     * The MSRtcSipDeploymentLocator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MSRtcSipDeploymentLocator;
    /**
     * The MSRtcSipPrimaryUserAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MSRtcSipPrimaryUserAddress;
    /**
     * The MobilePhone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobilePhone;
    /**
     * The ObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObjectId;
    /**
     * The Office
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Office;
    /**
     * The OverallProvisioningStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OverallProvisioningStatus;
    /**
     * The PasswordNeverExpires
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PasswordNeverExpires;
    /**
     * The PasswordResetNotRequiredDuringActivate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PasswordResetNotRequiredDuringActivate;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhoneNumber;
    /**
     * The PortalSettings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PortalSettings
     */
    public $PortalSettings;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostalCode;
    /**
     * The PreferredDataLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferredDataLocation;
    /**
     * The PreferredLanguage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferredLanguage;
    /**
     * The ProxyAddresses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $ProxyAddresses;
    /**
     * The ReleaseTrack
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReleaseTrack;
    /**
     * The ServiceInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfServiceInformation
     */
    public $ServiceInformation;
    /**
     * The SignInName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SignInName;
    /**
     * The SoftDeletionTimestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SoftDeletionTimestamp;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The StreetAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StreetAddress;
    /**
     * The StrongAuthenticationMethods
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfStrongAuthenticationMethod
     */
    public $StrongAuthenticationMethods;
    /**
     * The StrongAuthenticationPhoneAppDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfStrongAuthenticationPhoneAppDetail
     */
    public $StrongAuthenticationPhoneAppDetails;
    /**
     * The StrongAuthenticationProofupTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StrongAuthenticationProofupTime;
    /**
     * The StrongAuthenticationRequirements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfStrongAuthenticationRequirement
     */
    public $StrongAuthenticationRequirements;
    /**
     * The StrongAuthenticationUserDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StrongAuthenticationUserDetails
     */
    public $StrongAuthenticationUserDetails;
    /**
     * The StrongPasswordRequired
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $StrongPasswordRequired;
    /**
     * The StsRefreshTokensValidFrom
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StsRefreshTokensValidFrom;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The UsageLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UsageLocation;
    /**
     * The UserLandingPageIdentifierForO365Shell
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserLandingPageIdentifierForO365Shell;
    /**
     * The UserPrincipalName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserPrincipalName;
    /**
     * The UserThemeIdentifierForO365Shell
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserThemeIdentifierForO365Shell;
    /**
     * The UserType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserType;
    /**
     * The ValidationStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidationStatus;
    /**
     * The WhenCreated
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WhenCreated;
    /**
     * Constructor method for User
     * @uses User::setAlternateEmailAddresses()
     * @uses User::setAlternateMobilePhones()
     * @uses User::setAlternativeSecurityIds()
     * @uses User::setBlockCredential()
     * @uses User::setCity()
     * @uses User::setCloudExchangeRecipientDisplayType()
     * @uses User::setCountry()
     * @uses User::setDepartment()
     * @uses User::setDirSyncProvisioningErrors()
     * @uses User::setDisplayName()
     * @uses User::setErrors()
     * @uses User::setFax()
     * @uses User::setFirstName()
     * @uses User::setImmutableId()
     * @uses User::setIndirectLicenseErrors()
     * @uses User::setIsBlackberryUser()
     * @uses User::setIsLicensed()
     * @uses User::setLastDirSyncTime()
     * @uses User::setLastName()
     * @uses User::setLastPasswordChangeTimestamp()
     * @uses User::setLicenseAssignmentDetails()
     * @uses User::setLicenseReconciliationNeeded()
     * @uses User::setLicenses()
     * @uses User::setLiveId()
     * @uses User::setMSExchRecipientTypeDetails()
     * @uses User::setMSRtcSipDeploymentLocator()
     * @uses User::setMSRtcSipPrimaryUserAddress()
     * @uses User::setMobilePhone()
     * @uses User::setObjectId()
     * @uses User::setOffice()
     * @uses User::setOverallProvisioningStatus()
     * @uses User::setPasswordNeverExpires()
     * @uses User::setPasswordResetNotRequiredDuringActivate()
     * @uses User::setPhoneNumber()
     * @uses User::setPortalSettings()
     * @uses User::setPostalCode()
     * @uses User::setPreferredDataLocation()
     * @uses User::setPreferredLanguage()
     * @uses User::setProxyAddresses()
     * @uses User::setReleaseTrack()
     * @uses User::setServiceInformation()
     * @uses User::setSignInName()
     * @uses User::setSoftDeletionTimestamp()
     * @uses User::setState()
     * @uses User::setStreetAddress()
     * @uses User::setStrongAuthenticationMethods()
     * @uses User::setStrongAuthenticationPhoneAppDetails()
     * @uses User::setStrongAuthenticationProofupTime()
     * @uses User::setStrongAuthenticationRequirements()
     * @uses User::setStrongAuthenticationUserDetails()
     * @uses User::setStrongPasswordRequired()
     * @uses User::setStsRefreshTokensValidFrom()
     * @uses User::setTitle()
     * @uses User::setUsageLocation()
     * @uses User::setUserLandingPageIdentifierForO365Shell()
     * @uses User::setUserPrincipalName()
     * @uses User::setUserThemeIdentifierForO365Shell()
     * @uses User::setUserType()
     * @uses User::setValidationStatus()
     * @uses User::setWhenCreated()
     * @param \ArrayType\ArrayOfstring $alternateEmailAddresses
     * @param \ArrayType\ArrayOfstring $alternateMobilePhones
     * @param \ArrayType\ArrayOfAlternativeSecurityId $alternativeSecurityIds
     * @param bool $blockCredential
     * @param string $city
     * @param int $cloudExchangeRecipientDisplayType
     * @param string $country
     * @param string $department
     * @param \ArrayType\ArrayOfDirSyncProvisioningError $dirSyncProvisioningErrors
     * @param string $displayName
     * @param \ArrayType\ArrayOfValidationError $errors
     * @param string $fax
     * @param string $firstName
     * @param string $immutableId
     * @param \ArrayType\ArrayOfIndirectLicenseError $indirectLicenseErrors
     * @param bool $isBlackberryUser
     * @param bool $isLicensed
     * @param string $lastDirSyncTime
     * @param string $lastName
     * @param string $lastPasswordChangeTimestamp
     * @param \ArrayType\ArrayOfLicenseAssignmentDetail $licenseAssignmentDetails
     * @param bool $licenseReconciliationNeeded
     * @param \ArrayType\ArrayOfUserLicense $licenses
     * @param string $liveId
     * @param int $mSExchRecipientTypeDetails
     * @param string $mSRtcSipDeploymentLocator
     * @param string $mSRtcSipPrimaryUserAddress
     * @param string $mobilePhone
     * @param string $objectId
     * @param string $office
     * @param string $overallProvisioningStatus
     * @param bool $passwordNeverExpires
     * @param bool $passwordResetNotRequiredDuringActivate
     * @param string $phoneNumber
     * @param \StructType\PortalSettings $portalSettings
     * @param string $postalCode
     * @param string $preferredDataLocation
     * @param string $preferredLanguage
     * @param \ArrayType\ArrayOfstring $proxyAddresses
     * @param string $releaseTrack
     * @param \ArrayType\ArrayOfServiceInformation $serviceInformation
     * @param string $signInName
     * @param string $softDeletionTimestamp
     * @param string $state
     * @param string $streetAddress
     * @param \ArrayType\ArrayOfStrongAuthenticationMethod $strongAuthenticationMethods
     * @param \ArrayType\ArrayOfStrongAuthenticationPhoneAppDetail $strongAuthenticationPhoneAppDetails
     * @param int $strongAuthenticationProofupTime
     * @param \ArrayType\ArrayOfStrongAuthenticationRequirement $strongAuthenticationRequirements
     * @param \StructType\StrongAuthenticationUserDetails $strongAuthenticationUserDetails
     * @param bool $strongPasswordRequired
     * @param string $stsRefreshTokensValidFrom
     * @param string $title
     * @param string $usageLocation
     * @param string $userLandingPageIdentifierForO365Shell
     * @param string $userPrincipalName
     * @param string $userThemeIdentifierForO365Shell
     * @param string $userType
     * @param string $validationStatus
     * @param string $whenCreated
     */
    public function __construct(\ArrayType\ArrayOfstring $alternateEmailAddresses = null, \ArrayType\ArrayOfstring $alternateMobilePhones = null, \ArrayType\ArrayOfAlternativeSecurityId $alternativeSecurityIds = null, $blockCredential = null, $city = null, $cloudExchangeRecipientDisplayType = null, $country = null, $department = null, \ArrayType\ArrayOfDirSyncProvisioningError $dirSyncProvisioningErrors = null, $displayName = null, \ArrayType\ArrayOfValidationError $errors = null, $fax = null, $firstName = null, $immutableId = null, \ArrayType\ArrayOfIndirectLicenseError $indirectLicenseErrors = null, $isBlackberryUser = null, $isLicensed = null, $lastDirSyncTime = null, $lastName = null, $lastPasswordChangeTimestamp = null, \ArrayType\ArrayOfLicenseAssignmentDetail $licenseAssignmentDetails = null, $licenseReconciliationNeeded = null, \ArrayType\ArrayOfUserLicense $licenses = null, $liveId = null, $mSExchRecipientTypeDetails = null, $mSRtcSipDeploymentLocator = null, $mSRtcSipPrimaryUserAddress = null, $mobilePhone = null, $objectId = null, $office = null, $overallProvisioningStatus = null, $passwordNeverExpires = null, $passwordResetNotRequiredDuringActivate = null, $phoneNumber = null, \StructType\PortalSettings $portalSettings = null, $postalCode = null, $preferredDataLocation = null, $preferredLanguage = null, \ArrayType\ArrayOfstring $proxyAddresses = null, $releaseTrack = null, \ArrayType\ArrayOfServiceInformation $serviceInformation = null, $signInName = null, $softDeletionTimestamp = null, $state = null, $streetAddress = null, \ArrayType\ArrayOfStrongAuthenticationMethod $strongAuthenticationMethods = null, \ArrayType\ArrayOfStrongAuthenticationPhoneAppDetail $strongAuthenticationPhoneAppDetails = null, $strongAuthenticationProofupTime = null, \ArrayType\ArrayOfStrongAuthenticationRequirement $strongAuthenticationRequirements = null, \StructType\StrongAuthenticationUserDetails $strongAuthenticationUserDetails = null, $strongPasswordRequired = null, $stsRefreshTokensValidFrom = null, $title = null, $usageLocation = null, $userLandingPageIdentifierForO365Shell = null, $userPrincipalName = null, $userThemeIdentifierForO365Shell = null, $userType = null, $validationStatus = null, $whenCreated = null)
    {
        $this
            ->setAlternateEmailAddresses($alternateEmailAddresses)
            ->setAlternateMobilePhones($alternateMobilePhones)
            ->setAlternativeSecurityIds($alternativeSecurityIds)
            ->setBlockCredential($blockCredential)
            ->setCity($city)
            ->setCloudExchangeRecipientDisplayType($cloudExchangeRecipientDisplayType)
            ->setCountry($country)
            ->setDepartment($department)
            ->setDirSyncProvisioningErrors($dirSyncProvisioningErrors)
            ->setDisplayName($displayName)
            ->setErrors($errors)
            ->setFax($fax)
            ->setFirstName($firstName)
            ->setImmutableId($immutableId)
            ->setIndirectLicenseErrors($indirectLicenseErrors)
            ->setIsBlackberryUser($isBlackberryUser)
            ->setIsLicensed($isLicensed)
            ->setLastDirSyncTime($lastDirSyncTime)
            ->setLastName($lastName)
            ->setLastPasswordChangeTimestamp($lastPasswordChangeTimestamp)
            ->setLicenseAssignmentDetails($licenseAssignmentDetails)
            ->setLicenseReconciliationNeeded($licenseReconciliationNeeded)
            ->setLicenses($licenses)
            ->setLiveId($liveId)
            ->setMSExchRecipientTypeDetails($mSExchRecipientTypeDetails)
            ->setMSRtcSipDeploymentLocator($mSRtcSipDeploymentLocator)
            ->setMSRtcSipPrimaryUserAddress($mSRtcSipPrimaryUserAddress)
            ->setMobilePhone($mobilePhone)
            ->setObjectId($objectId)
            ->setOffice($office)
            ->setOverallProvisioningStatus($overallProvisioningStatus)
            ->setPasswordNeverExpires($passwordNeverExpires)
            ->setPasswordResetNotRequiredDuringActivate($passwordResetNotRequiredDuringActivate)
            ->setPhoneNumber($phoneNumber)
            ->setPortalSettings($portalSettings)
            ->setPostalCode($postalCode)
            ->setPreferredDataLocation($preferredDataLocation)
            ->setPreferredLanguage($preferredLanguage)
            ->setProxyAddresses($proxyAddresses)
            ->setReleaseTrack($releaseTrack)
            ->setServiceInformation($serviceInformation)
            ->setSignInName($signInName)
            ->setSoftDeletionTimestamp($softDeletionTimestamp)
            ->setState($state)
            ->setStreetAddress($streetAddress)
            ->setStrongAuthenticationMethods($strongAuthenticationMethods)
            ->setStrongAuthenticationPhoneAppDetails($strongAuthenticationPhoneAppDetails)
            ->setStrongAuthenticationProofupTime($strongAuthenticationProofupTime)
            ->setStrongAuthenticationRequirements($strongAuthenticationRequirements)
            ->setStrongAuthenticationUserDetails($strongAuthenticationUserDetails)
            ->setStrongPasswordRequired($strongPasswordRequired)
            ->setStsRefreshTokensValidFrom($stsRefreshTokensValidFrom)
            ->setTitle($title)
            ->setUsageLocation($usageLocation)
            ->setUserLandingPageIdentifierForO365Shell($userLandingPageIdentifierForO365Shell)
            ->setUserPrincipalName($userPrincipalName)
            ->setUserThemeIdentifierForO365Shell($userThemeIdentifierForO365Shell)
            ->setUserType($userType)
            ->setValidationStatus($validationStatus)
            ->setWhenCreated($whenCreated);
    }
    /**
     * Get AlternateEmailAddresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getAlternateEmailAddresses()
    {
        return isset($this->AlternateEmailAddresses) ? $this->AlternateEmailAddresses : null;
    }
    /**
     * Set AlternateEmailAddresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $alternateEmailAddresses
     * @return \StructType\User
     */
    public function setAlternateEmailAddresses(\ArrayType\ArrayOfstring $alternateEmailAddresses = null)
    {
        if (is_null($alternateEmailAddresses) || (is_array($alternateEmailAddresses) && empty($alternateEmailAddresses))) {
            unset($this->AlternateEmailAddresses);
        } else {
            $this->AlternateEmailAddresses = $alternateEmailAddresses;
        }
        return $this;
    }
    /**
     * Get AlternateMobilePhones value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getAlternateMobilePhones()
    {
        return isset($this->AlternateMobilePhones) ? $this->AlternateMobilePhones : null;
    }
    /**
     * Set AlternateMobilePhones value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $alternateMobilePhones
     * @return \StructType\User
     */
    public function setAlternateMobilePhones(\ArrayType\ArrayOfstring $alternateMobilePhones = null)
    {
        if (is_null($alternateMobilePhones) || (is_array($alternateMobilePhones) && empty($alternateMobilePhones))) {
            unset($this->AlternateMobilePhones);
        } else {
            $this->AlternateMobilePhones = $alternateMobilePhones;
        }
        return $this;
    }
    /**
     * Get AlternativeSecurityIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAlternativeSecurityId|null
     */
    public function getAlternativeSecurityIds()
    {
        return isset($this->AlternativeSecurityIds) ? $this->AlternativeSecurityIds : null;
    }
    /**
     * Set AlternativeSecurityIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAlternativeSecurityId $alternativeSecurityIds
     * @return \StructType\User
     */
    public function setAlternativeSecurityIds(\ArrayType\ArrayOfAlternativeSecurityId $alternativeSecurityIds = null)
    {
        if (is_null($alternativeSecurityIds) || (is_array($alternativeSecurityIds) && empty($alternativeSecurityIds))) {
            unset($this->AlternativeSecurityIds);
        } else {
            $this->AlternativeSecurityIds = $alternativeSecurityIds;
        }
        return $this;
    }
    /**
     * Get BlockCredential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBlockCredential()
    {
        return isset($this->BlockCredential) ? $this->BlockCredential : null;
    }
    /**
     * Set BlockCredential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $blockCredential
     * @return \StructType\User
     */
    public function setBlockCredential($blockCredential = null)
    {
        if (is_null($blockCredential) || (is_array($blockCredential) && empty($blockCredential))) {
            unset($this->BlockCredential);
        } else {
            $this->BlockCredential = $blockCredential;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \StructType\User
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get CloudExchangeRecipientDisplayType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCloudExchangeRecipientDisplayType()
    {
        return isset($this->CloudExchangeRecipientDisplayType) ? $this->CloudExchangeRecipientDisplayType : null;
    }
    /**
     * Set CloudExchangeRecipientDisplayType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cloudExchangeRecipientDisplayType
     * @return \StructType\User
     */
    public function setCloudExchangeRecipientDisplayType($cloudExchangeRecipientDisplayType = null)
    {
        // validation for constraint: int
        if (!is_null($cloudExchangeRecipientDisplayType) && !is_numeric($cloudExchangeRecipientDisplayType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cloudExchangeRecipientDisplayType)), __LINE__);
        }
        if (is_null($cloudExchangeRecipientDisplayType) || (is_array($cloudExchangeRecipientDisplayType) && empty($cloudExchangeRecipientDisplayType))) {
            unset($this->CloudExchangeRecipientDisplayType);
        } else {
            $this->CloudExchangeRecipientDisplayType = $cloudExchangeRecipientDisplayType;
        }
        return $this;
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country
     * @return \StructType\User
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Get Department value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartment()
    {
        return isset($this->Department) ? $this->Department : null;
    }
    /**
     * Set Department value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $department
     * @return \StructType\User
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($department)), __LINE__);
        }
        if (is_null($department) || (is_array($department) && empty($department))) {
            unset($this->Department);
        } else {
            $this->Department = $department;
        }
        return $this;
    }
    /**
     * Get DirSyncProvisioningErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDirSyncProvisioningError|null
     */
    public function getDirSyncProvisioningErrors()
    {
        return isset($this->DirSyncProvisioningErrors) ? $this->DirSyncProvisioningErrors : null;
    }
    /**
     * Set DirSyncProvisioningErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDirSyncProvisioningError $dirSyncProvisioningErrors
     * @return \StructType\User
     */
    public function setDirSyncProvisioningErrors(\ArrayType\ArrayOfDirSyncProvisioningError $dirSyncProvisioningErrors = null)
    {
        if (is_null($dirSyncProvisioningErrors) || (is_array($dirSyncProvisioningErrors) && empty($dirSyncProvisioningErrors))) {
            unset($this->DirSyncProvisioningErrors);
        } else {
            $this->DirSyncProvisioningErrors = $dirSyncProvisioningErrors;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \StructType\User
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get Errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfValidationError|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * Set Errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfValidationError $errors
     * @return \StructType\User
     */
    public function setErrors(\ArrayType\ArrayOfValidationError $errors = null)
    {
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get Fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax()
    {
        return isset($this->Fax) ? $this->Fax : null;
    }
    /**
     * Set Fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax
     * @return \StructType\User
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fax)), __LINE__);
        }
        if (is_null($fax) || (is_array($fax) && empty($fax))) {
            unset($this->Fax);
        } else {
            $this->Fax = $fax;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \StructType\User
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get ImmutableId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImmutableId()
    {
        return isset($this->ImmutableId) ? $this->ImmutableId : null;
    }
    /**
     * Set ImmutableId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $immutableId
     * @return \StructType\User
     */
    public function setImmutableId($immutableId = null)
    {
        // validation for constraint: string
        if (!is_null($immutableId) && !is_string($immutableId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($immutableId)), __LINE__);
        }
        if (is_null($immutableId) || (is_array($immutableId) && empty($immutableId))) {
            unset($this->ImmutableId);
        } else {
            $this->ImmutableId = $immutableId;
        }
        return $this;
    }
    /**
     * Get IndirectLicenseErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfIndirectLicenseError|null
     */
    public function getIndirectLicenseErrors()
    {
        return isset($this->IndirectLicenseErrors) ? $this->IndirectLicenseErrors : null;
    }
    /**
     * Set IndirectLicenseErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfIndirectLicenseError $indirectLicenseErrors
     * @return \StructType\User
     */
    public function setIndirectLicenseErrors(\ArrayType\ArrayOfIndirectLicenseError $indirectLicenseErrors = null)
    {
        if (is_null($indirectLicenseErrors) || (is_array($indirectLicenseErrors) && empty($indirectLicenseErrors))) {
            unset($this->IndirectLicenseErrors);
        } else {
            $this->IndirectLicenseErrors = $indirectLicenseErrors;
        }
        return $this;
    }
    /**
     * Get IsBlackberryUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsBlackberryUser()
    {
        return isset($this->IsBlackberryUser) ? $this->IsBlackberryUser : null;
    }
    /**
     * Set IsBlackberryUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isBlackberryUser
     * @return \StructType\User
     */
    public function setIsBlackberryUser($isBlackberryUser = null)
    {
        if (is_null($isBlackberryUser) || (is_array($isBlackberryUser) && empty($isBlackberryUser))) {
            unset($this->IsBlackberryUser);
        } else {
            $this->IsBlackberryUser = $isBlackberryUser;
        }
        return $this;
    }
    /**
     * Get IsLicensed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsLicensed()
    {
        return isset($this->IsLicensed) ? $this->IsLicensed : null;
    }
    /**
     * Set IsLicensed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isLicensed
     * @return \StructType\User
     */
    public function setIsLicensed($isLicensed = null)
    {
        if (is_null($isLicensed) || (is_array($isLicensed) && empty($isLicensed))) {
            unset($this->IsLicensed);
        } else {
            $this->IsLicensed = $isLicensed;
        }
        return $this;
    }
    /**
     * Get LastDirSyncTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastDirSyncTime()
    {
        return isset($this->LastDirSyncTime) ? $this->LastDirSyncTime : null;
    }
    /**
     * Set LastDirSyncTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastDirSyncTime
     * @return \StructType\User
     */
    public function setLastDirSyncTime($lastDirSyncTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastDirSyncTime) && !is_string($lastDirSyncTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastDirSyncTime)), __LINE__);
        }
        if (is_null($lastDirSyncTime) || (is_array($lastDirSyncTime) && empty($lastDirSyncTime))) {
            unset($this->LastDirSyncTime);
        } else {
            $this->LastDirSyncTime = $lastDirSyncTime;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \StructType\User
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get LastPasswordChangeTimestamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastPasswordChangeTimestamp()
    {
        return isset($this->LastPasswordChangeTimestamp) ? $this->LastPasswordChangeTimestamp : null;
    }
    /**
     * Set LastPasswordChangeTimestamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastPasswordChangeTimestamp
     * @return \StructType\User
     */
    public function setLastPasswordChangeTimestamp($lastPasswordChangeTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($lastPasswordChangeTimestamp) && !is_string($lastPasswordChangeTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastPasswordChangeTimestamp)), __LINE__);
        }
        if (is_null($lastPasswordChangeTimestamp) || (is_array($lastPasswordChangeTimestamp) && empty($lastPasswordChangeTimestamp))) {
            unset($this->LastPasswordChangeTimestamp);
        } else {
            $this->LastPasswordChangeTimestamp = $lastPasswordChangeTimestamp;
        }
        return $this;
    }
    /**
     * Get LicenseAssignmentDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLicenseAssignmentDetail|null
     */
    public function getLicenseAssignmentDetails()
    {
        return isset($this->LicenseAssignmentDetails) ? $this->LicenseAssignmentDetails : null;
    }
    /**
     * Set LicenseAssignmentDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLicenseAssignmentDetail $licenseAssignmentDetails
     * @return \StructType\User
     */
    public function setLicenseAssignmentDetails(\ArrayType\ArrayOfLicenseAssignmentDetail $licenseAssignmentDetails = null)
    {
        if (is_null($licenseAssignmentDetails) || (is_array($licenseAssignmentDetails) && empty($licenseAssignmentDetails))) {
            unset($this->LicenseAssignmentDetails);
        } else {
            $this->LicenseAssignmentDetails = $licenseAssignmentDetails;
        }
        return $this;
    }
    /**
     * Get LicenseReconciliationNeeded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLicenseReconciliationNeeded()
    {
        return isset($this->LicenseReconciliationNeeded) ? $this->LicenseReconciliationNeeded : null;
    }
    /**
     * Set LicenseReconciliationNeeded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $licenseReconciliationNeeded
     * @return \StructType\User
     */
    public function setLicenseReconciliationNeeded($licenseReconciliationNeeded = null)
    {
        if (is_null($licenseReconciliationNeeded) || (is_array($licenseReconciliationNeeded) && empty($licenseReconciliationNeeded))) {
            unset($this->LicenseReconciliationNeeded);
        } else {
            $this->LicenseReconciliationNeeded = $licenseReconciliationNeeded;
        }
        return $this;
    }
    /**
     * Get Licenses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfUserLicense|null
     */
    public function getLicenses()
    {
        return isset($this->Licenses) ? $this->Licenses : null;
    }
    /**
     * Set Licenses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfUserLicense $licenses
     * @return \StructType\User
     */
    public function setLicenses(\ArrayType\ArrayOfUserLicense $licenses = null)
    {
        if (is_null($licenses) || (is_array($licenses) && empty($licenses))) {
            unset($this->Licenses);
        } else {
            $this->Licenses = $licenses;
        }
        return $this;
    }
    /**
     * Get LiveId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLiveId()
    {
        return isset($this->LiveId) ? $this->LiveId : null;
    }
    /**
     * Set LiveId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $liveId
     * @return \StructType\User
     */
    public function setLiveId($liveId = null)
    {
        // validation for constraint: string
        if (!is_null($liveId) && !is_string($liveId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($liveId)), __LINE__);
        }
        if (is_null($liveId) || (is_array($liveId) && empty($liveId))) {
            unset($this->LiveId);
        } else {
            $this->LiveId = $liveId;
        }
        return $this;
    }
    /**
     * Get MSExchRecipientTypeDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMSExchRecipientTypeDetails()
    {
        return isset($this->MSExchRecipientTypeDetails) ? $this->MSExchRecipientTypeDetails : null;
    }
    /**
     * Set MSExchRecipientTypeDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mSExchRecipientTypeDetails
     * @return \StructType\User
     */
    public function setMSExchRecipientTypeDetails($mSExchRecipientTypeDetails = null)
    {
        // validation for constraint: int
        if (!is_null($mSExchRecipientTypeDetails) && !is_numeric($mSExchRecipientTypeDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($mSExchRecipientTypeDetails)), __LINE__);
        }
        if (is_null($mSExchRecipientTypeDetails) || (is_array($mSExchRecipientTypeDetails) && empty($mSExchRecipientTypeDetails))) {
            unset($this->MSExchRecipientTypeDetails);
        } else {
            $this->MSExchRecipientTypeDetails = $mSExchRecipientTypeDetails;
        }
        return $this;
    }
    /**
     * Get MSRtcSipDeploymentLocator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMSRtcSipDeploymentLocator()
    {
        return isset($this->MSRtcSipDeploymentLocator) ? $this->MSRtcSipDeploymentLocator : null;
    }
    /**
     * Set MSRtcSipDeploymentLocator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mSRtcSipDeploymentLocator
     * @return \StructType\User
     */
    public function setMSRtcSipDeploymentLocator($mSRtcSipDeploymentLocator = null)
    {
        // validation for constraint: string
        if (!is_null($mSRtcSipDeploymentLocator) && !is_string($mSRtcSipDeploymentLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mSRtcSipDeploymentLocator)), __LINE__);
        }
        if (is_null($mSRtcSipDeploymentLocator) || (is_array($mSRtcSipDeploymentLocator) && empty($mSRtcSipDeploymentLocator))) {
            unset($this->MSRtcSipDeploymentLocator);
        } else {
            $this->MSRtcSipDeploymentLocator = $mSRtcSipDeploymentLocator;
        }
        return $this;
    }
    /**
     * Get MSRtcSipPrimaryUserAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMSRtcSipPrimaryUserAddress()
    {
        return isset($this->MSRtcSipPrimaryUserAddress) ? $this->MSRtcSipPrimaryUserAddress : null;
    }
    /**
     * Set MSRtcSipPrimaryUserAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mSRtcSipPrimaryUserAddress
     * @return \StructType\User
     */
    public function setMSRtcSipPrimaryUserAddress($mSRtcSipPrimaryUserAddress = null)
    {
        // validation for constraint: string
        if (!is_null($mSRtcSipPrimaryUserAddress) && !is_string($mSRtcSipPrimaryUserAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mSRtcSipPrimaryUserAddress)), __LINE__);
        }
        if (is_null($mSRtcSipPrimaryUserAddress) || (is_array($mSRtcSipPrimaryUserAddress) && empty($mSRtcSipPrimaryUserAddress))) {
            unset($this->MSRtcSipPrimaryUserAddress);
        } else {
            $this->MSRtcSipPrimaryUserAddress = $mSRtcSipPrimaryUserAddress;
        }
        return $this;
    }
    /**
     * Get MobilePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobilePhone()
    {
        return isset($this->MobilePhone) ? $this->MobilePhone : null;
    }
    /**
     * Set MobilePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobilePhone
     * @return \StructType\User
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mobilePhone)), __LINE__);
        }
        if (is_null($mobilePhone) || (is_array($mobilePhone) && empty($mobilePhone))) {
            unset($this->MobilePhone);
        } else {
            $this->MobilePhone = $mobilePhone;
        }
        return $this;
    }
    /**
     * Get ObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObjectId()
    {
        return isset($this->ObjectId) ? $this->ObjectId : null;
    }
    /**
     * Set ObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $objectId
     * @return \StructType\User
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($objectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($objectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectId)), __LINE__);
        }
        if (is_null($objectId) || (is_array($objectId) && empty($objectId))) {
            unset($this->ObjectId);
        } else {
            $this->ObjectId = $objectId;
        }
        return $this;
    }
    /**
     * Get Office value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOffice()
    {
        return isset($this->Office) ? $this->Office : null;
    }
    /**
     * Set Office value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $office
     * @return \StructType\User
     */
    public function setOffice($office = null)
    {
        // validation for constraint: string
        if (!is_null($office) && !is_string($office)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($office)), __LINE__);
        }
        if (is_null($office) || (is_array($office) && empty($office))) {
            unset($this->Office);
        } else {
            $this->Office = $office;
        }
        return $this;
    }
    /**
     * Get OverallProvisioningStatus value
     * @return string|null
     */
    public function getOverallProvisioningStatus()
    {
        return $this->OverallProvisioningStatus;
    }
    /**
     * Set OverallProvisioningStatus value
     * @uses \EnumType\ProvisioningStatus::valueIsValid()
     * @uses \EnumType\ProvisioningStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $overallProvisioningStatus
     * @return \StructType\User
     */
    public function setOverallProvisioningStatus($overallProvisioningStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProvisioningStatus::valueIsValid($overallProvisioningStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $overallProvisioningStatus, implode(', ', \EnumType\ProvisioningStatus::getValidValues())), __LINE__);
        }
        $this->OverallProvisioningStatus = $overallProvisioningStatus;
        return $this;
    }
    /**
     * Get PasswordNeverExpires value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPasswordNeverExpires()
    {
        return isset($this->PasswordNeverExpires) ? $this->PasswordNeverExpires : null;
    }
    /**
     * Set PasswordNeverExpires value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $passwordNeverExpires
     * @return \StructType\User
     */
    public function setPasswordNeverExpires($passwordNeverExpires = null)
    {
        if (is_null($passwordNeverExpires) || (is_array($passwordNeverExpires) && empty($passwordNeverExpires))) {
            unset($this->PasswordNeverExpires);
        } else {
            $this->PasswordNeverExpires = $passwordNeverExpires;
        }
        return $this;
    }
    /**
     * Get PasswordResetNotRequiredDuringActivate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPasswordResetNotRequiredDuringActivate()
    {
        return isset($this->PasswordResetNotRequiredDuringActivate) ? $this->PasswordResetNotRequiredDuringActivate : null;
    }
    /**
     * Set PasswordResetNotRequiredDuringActivate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $passwordResetNotRequiredDuringActivate
     * @return \StructType\User
     */
    public function setPasswordResetNotRequiredDuringActivate($passwordResetNotRequiredDuringActivate = null)
    {
        if (is_null($passwordResetNotRequiredDuringActivate) || (is_array($passwordResetNotRequiredDuringActivate) && empty($passwordResetNotRequiredDuringActivate))) {
            unset($this->PasswordResetNotRequiredDuringActivate);
        } else {
            $this->PasswordResetNotRequiredDuringActivate = $passwordResetNotRequiredDuringActivate;
        }
        return $this;
    }
    /**
     * Get PhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return isset($this->PhoneNumber) ? $this->PhoneNumber : null;
    }
    /**
     * Set PhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phoneNumber
     * @return \StructType\User
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        if (is_null($phoneNumber) || (is_array($phoneNumber) && empty($phoneNumber))) {
            unset($this->PhoneNumber);
        } else {
            $this->PhoneNumber = $phoneNumber;
        }
        return $this;
    }
    /**
     * Get PortalSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PortalSettings|null
     */
    public function getPortalSettings()
    {
        return isset($this->PortalSettings) ? $this->PortalSettings : null;
    }
    /**
     * Set PortalSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PortalSettings $portalSettings
     * @return \StructType\User
     */
    public function setPortalSettings(\StructType\PortalSettings $portalSettings = null)
    {
        if (is_null($portalSettings) || (is_array($portalSettings) && empty($portalSettings))) {
            unset($this->PortalSettings);
        } else {
            $this->PortalSettings = $portalSettings;
        }
        return $this;
    }
    /**
     * Get PostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostalCode()
    {
        return isset($this->PostalCode) ? $this->PostalCode : null;
    }
    /**
     * Set PostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postalCode
     * @return \StructType\User
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        if (is_null($postalCode) || (is_array($postalCode) && empty($postalCode))) {
            unset($this->PostalCode);
        } else {
            $this->PostalCode = $postalCode;
        }
        return $this;
    }
    /**
     * Get PreferredDataLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredDataLocation()
    {
        return isset($this->PreferredDataLocation) ? $this->PreferredDataLocation : null;
    }
    /**
     * Set PreferredDataLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredDataLocation
     * @return \StructType\User
     */
    public function setPreferredDataLocation($preferredDataLocation = null)
    {
        // validation for constraint: string
        if (!is_null($preferredDataLocation) && !is_string($preferredDataLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preferredDataLocation)), __LINE__);
        }
        if (is_null($preferredDataLocation) || (is_array($preferredDataLocation) && empty($preferredDataLocation))) {
            unset($this->PreferredDataLocation);
        } else {
            $this->PreferredDataLocation = $preferredDataLocation;
        }
        return $this;
    }
    /**
     * Get PreferredLanguage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredLanguage()
    {
        return isset($this->PreferredLanguage) ? $this->PreferredLanguage : null;
    }
    /**
     * Set PreferredLanguage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredLanguage
     * @return \StructType\User
     */
    public function setPreferredLanguage($preferredLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($preferredLanguage) && !is_string($preferredLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preferredLanguage)), __LINE__);
        }
        if (is_null($preferredLanguage) || (is_array($preferredLanguage) && empty($preferredLanguage))) {
            unset($this->PreferredLanguage);
        } else {
            $this->PreferredLanguage = $preferredLanguage;
        }
        return $this;
    }
    /**
     * Get ProxyAddresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getProxyAddresses()
    {
        return isset($this->ProxyAddresses) ? $this->ProxyAddresses : null;
    }
    /**
     * Set ProxyAddresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $proxyAddresses
     * @return \StructType\User
     */
    public function setProxyAddresses(\ArrayType\ArrayOfstring $proxyAddresses = null)
    {
        if (is_null($proxyAddresses) || (is_array($proxyAddresses) && empty($proxyAddresses))) {
            unset($this->ProxyAddresses);
        } else {
            $this->ProxyAddresses = $proxyAddresses;
        }
        return $this;
    }
    /**
     * Get ReleaseTrack value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReleaseTrack()
    {
        return isset($this->ReleaseTrack) ? $this->ReleaseTrack : null;
    }
    /**
     * Set ReleaseTrack value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\O365UserReleaseTrack::valueIsValid()
     * @uses \EnumType\O365UserReleaseTrack::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $releaseTrack
     * @return \StructType\User
     */
    public function setReleaseTrack($releaseTrack = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\O365UserReleaseTrack::valueIsValid($releaseTrack)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $releaseTrack, implode(', ', \EnumType\O365UserReleaseTrack::getValidValues())), __LINE__);
        }
        if (is_null($releaseTrack) || (is_array($releaseTrack) && empty($releaseTrack))) {
            unset($this->ReleaseTrack);
        } else {
            $this->ReleaseTrack = $releaseTrack;
        }
        return $this;
    }
    /**
     * Get ServiceInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfServiceInformation|null
     */
    public function getServiceInformation()
    {
        return isset($this->ServiceInformation) ? $this->ServiceInformation : null;
    }
    /**
     * Set ServiceInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfServiceInformation $serviceInformation
     * @return \StructType\User
     */
    public function setServiceInformation(\ArrayType\ArrayOfServiceInformation $serviceInformation = null)
    {
        if (is_null($serviceInformation) || (is_array($serviceInformation) && empty($serviceInformation))) {
            unset($this->ServiceInformation);
        } else {
            $this->ServiceInformation = $serviceInformation;
        }
        return $this;
    }
    /**
     * Get SignInName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSignInName()
    {
        return isset($this->SignInName) ? $this->SignInName : null;
    }
    /**
     * Set SignInName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $signInName
     * @return \StructType\User
     */
    public function setSignInName($signInName = null)
    {
        // validation for constraint: string
        if (!is_null($signInName) && !is_string($signInName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signInName)), __LINE__);
        }
        if (is_null($signInName) || (is_array($signInName) && empty($signInName))) {
            unset($this->SignInName);
        } else {
            $this->SignInName = $signInName;
        }
        return $this;
    }
    /**
     * Get SoftDeletionTimestamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSoftDeletionTimestamp()
    {
        return isset($this->SoftDeletionTimestamp) ? $this->SoftDeletionTimestamp : null;
    }
    /**
     * Set SoftDeletionTimestamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $softDeletionTimestamp
     * @return \StructType\User
     */
    public function setSoftDeletionTimestamp($softDeletionTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($softDeletionTimestamp) && !is_string($softDeletionTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($softDeletionTimestamp)), __LINE__);
        }
        if (is_null($softDeletionTimestamp) || (is_array($softDeletionTimestamp) && empty($softDeletionTimestamp))) {
            unset($this->SoftDeletionTimestamp);
        } else {
            $this->SoftDeletionTimestamp = $softDeletionTimestamp;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \StructType\User
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get StreetAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetAddress()
    {
        return isset($this->StreetAddress) ? $this->StreetAddress : null;
    }
    /**
     * Set StreetAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetAddress
     * @return \StructType\User
     */
    public function setStreetAddress($streetAddress = null)
    {
        // validation for constraint: string
        if (!is_null($streetAddress) && !is_string($streetAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetAddress)), __LINE__);
        }
        if (is_null($streetAddress) || (is_array($streetAddress) && empty($streetAddress))) {
            unset($this->StreetAddress);
        } else {
            $this->StreetAddress = $streetAddress;
        }
        return $this;
    }
    /**
     * Get StrongAuthenticationMethods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfStrongAuthenticationMethod|null
     */
    public function getStrongAuthenticationMethods()
    {
        return isset($this->StrongAuthenticationMethods) ? $this->StrongAuthenticationMethods : null;
    }
    /**
     * Set StrongAuthenticationMethods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfStrongAuthenticationMethod $strongAuthenticationMethods
     * @return \StructType\User
     */
    public function setStrongAuthenticationMethods(\ArrayType\ArrayOfStrongAuthenticationMethod $strongAuthenticationMethods = null)
    {
        if (is_null($strongAuthenticationMethods) || (is_array($strongAuthenticationMethods) && empty($strongAuthenticationMethods))) {
            unset($this->StrongAuthenticationMethods);
        } else {
            $this->StrongAuthenticationMethods = $strongAuthenticationMethods;
        }
        return $this;
    }
    /**
     * Get StrongAuthenticationPhoneAppDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfStrongAuthenticationPhoneAppDetail|null
     */
    public function getStrongAuthenticationPhoneAppDetails()
    {
        return isset($this->StrongAuthenticationPhoneAppDetails) ? $this->StrongAuthenticationPhoneAppDetails : null;
    }
    /**
     * Set StrongAuthenticationPhoneAppDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfStrongAuthenticationPhoneAppDetail $strongAuthenticationPhoneAppDetails
     * @return \StructType\User
     */
    public function setStrongAuthenticationPhoneAppDetails(\ArrayType\ArrayOfStrongAuthenticationPhoneAppDetail $strongAuthenticationPhoneAppDetails = null)
    {
        if (is_null($strongAuthenticationPhoneAppDetails) || (is_array($strongAuthenticationPhoneAppDetails) && empty($strongAuthenticationPhoneAppDetails))) {
            unset($this->StrongAuthenticationPhoneAppDetails);
        } else {
            $this->StrongAuthenticationPhoneAppDetails = $strongAuthenticationPhoneAppDetails;
        }
        return $this;
    }
    /**
     * Get StrongAuthenticationProofupTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStrongAuthenticationProofupTime()
    {
        return isset($this->StrongAuthenticationProofupTime) ? $this->StrongAuthenticationProofupTime : null;
    }
    /**
     * Set StrongAuthenticationProofupTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $strongAuthenticationProofupTime
     * @return \StructType\User
     */
    public function setStrongAuthenticationProofupTime($strongAuthenticationProofupTime = null)
    {
        // validation for constraint: int
        if (!is_null($strongAuthenticationProofupTime) && !is_numeric($strongAuthenticationProofupTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($strongAuthenticationProofupTime)), __LINE__);
        }
        if (is_null($strongAuthenticationProofupTime) || (is_array($strongAuthenticationProofupTime) && empty($strongAuthenticationProofupTime))) {
            unset($this->StrongAuthenticationProofupTime);
        } else {
            $this->StrongAuthenticationProofupTime = $strongAuthenticationProofupTime;
        }
        return $this;
    }
    /**
     * Get StrongAuthenticationRequirements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfStrongAuthenticationRequirement|null
     */
    public function getStrongAuthenticationRequirements()
    {
        return isset($this->StrongAuthenticationRequirements) ? $this->StrongAuthenticationRequirements : null;
    }
    /**
     * Set StrongAuthenticationRequirements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfStrongAuthenticationRequirement $strongAuthenticationRequirements
     * @return \StructType\User
     */
    public function setStrongAuthenticationRequirements(\ArrayType\ArrayOfStrongAuthenticationRequirement $strongAuthenticationRequirements = null)
    {
        if (is_null($strongAuthenticationRequirements) || (is_array($strongAuthenticationRequirements) && empty($strongAuthenticationRequirements))) {
            unset($this->StrongAuthenticationRequirements);
        } else {
            $this->StrongAuthenticationRequirements = $strongAuthenticationRequirements;
        }
        return $this;
    }
    /**
     * Get StrongAuthenticationUserDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StrongAuthenticationUserDetails|null
     */
    public function getStrongAuthenticationUserDetails()
    {
        return isset($this->StrongAuthenticationUserDetails) ? $this->StrongAuthenticationUserDetails : null;
    }
    /**
     * Set StrongAuthenticationUserDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StrongAuthenticationUserDetails $strongAuthenticationUserDetails
     * @return \StructType\User
     */
    public function setStrongAuthenticationUserDetails(\StructType\StrongAuthenticationUserDetails $strongAuthenticationUserDetails = null)
    {
        if (is_null($strongAuthenticationUserDetails) || (is_array($strongAuthenticationUserDetails) && empty($strongAuthenticationUserDetails))) {
            unset($this->StrongAuthenticationUserDetails);
        } else {
            $this->StrongAuthenticationUserDetails = $strongAuthenticationUserDetails;
        }
        return $this;
    }
    /**
     * Get StrongPasswordRequired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getStrongPasswordRequired()
    {
        return isset($this->StrongPasswordRequired) ? $this->StrongPasswordRequired : null;
    }
    /**
     * Set StrongPasswordRequired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $strongPasswordRequired
     * @return \StructType\User
     */
    public function setStrongPasswordRequired($strongPasswordRequired = null)
    {
        if (is_null($strongPasswordRequired) || (is_array($strongPasswordRequired) && empty($strongPasswordRequired))) {
            unset($this->StrongPasswordRequired);
        } else {
            $this->StrongPasswordRequired = $strongPasswordRequired;
        }
        return $this;
    }
    /**
     * Get StsRefreshTokensValidFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStsRefreshTokensValidFrom()
    {
        return isset($this->StsRefreshTokensValidFrom) ? $this->StsRefreshTokensValidFrom : null;
    }
    /**
     * Set StsRefreshTokensValidFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stsRefreshTokensValidFrom
     * @return \StructType\User
     */
    public function setStsRefreshTokensValidFrom($stsRefreshTokensValidFrom = null)
    {
        // validation for constraint: string
        if (!is_null($stsRefreshTokensValidFrom) && !is_string($stsRefreshTokensValidFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stsRefreshTokensValidFrom)), __LINE__);
        }
        if (is_null($stsRefreshTokensValidFrom) || (is_array($stsRefreshTokensValidFrom) && empty($stsRefreshTokensValidFrom))) {
            unset($this->StsRefreshTokensValidFrom);
        } else {
            $this->StsRefreshTokensValidFrom = $stsRefreshTokensValidFrom;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \StructType\User
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Get UsageLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsageLocation()
    {
        return isset($this->UsageLocation) ? $this->UsageLocation : null;
    }
    /**
     * Set UsageLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $usageLocation
     * @return \StructType\User
     */
    public function setUsageLocation($usageLocation = null)
    {
        // validation for constraint: string
        if (!is_null($usageLocation) && !is_string($usageLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usageLocation)), __LINE__);
        }
        if (is_null($usageLocation) || (is_array($usageLocation) && empty($usageLocation))) {
            unset($this->UsageLocation);
        } else {
            $this->UsageLocation = $usageLocation;
        }
        return $this;
    }
    /**
     * Get UserLandingPageIdentifierForO365Shell value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLandingPageIdentifierForO365Shell()
    {
        return isset($this->UserLandingPageIdentifierForO365Shell) ? $this->UserLandingPageIdentifierForO365Shell : null;
    }
    /**
     * Set UserLandingPageIdentifierForO365Shell value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userLandingPageIdentifierForO365Shell
     * @return \StructType\User
     */
    public function setUserLandingPageIdentifierForO365Shell($userLandingPageIdentifierForO365Shell = null)
    {
        // validation for constraint: string
        if (!is_null($userLandingPageIdentifierForO365Shell) && !is_string($userLandingPageIdentifierForO365Shell)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLandingPageIdentifierForO365Shell)), __LINE__);
        }
        if (is_null($userLandingPageIdentifierForO365Shell) || (is_array($userLandingPageIdentifierForO365Shell) && empty($userLandingPageIdentifierForO365Shell))) {
            unset($this->UserLandingPageIdentifierForO365Shell);
        } else {
            $this->UserLandingPageIdentifierForO365Shell = $userLandingPageIdentifierForO365Shell;
        }
        return $this;
    }
    /**
     * Get UserPrincipalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserPrincipalName()
    {
        return isset($this->UserPrincipalName) ? $this->UserPrincipalName : null;
    }
    /**
     * Set UserPrincipalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userPrincipalName
     * @return \StructType\User
     */
    public function setUserPrincipalName($userPrincipalName = null)
    {
        // validation for constraint: string
        if (!is_null($userPrincipalName) && !is_string($userPrincipalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userPrincipalName)), __LINE__);
        }
        if (is_null($userPrincipalName) || (is_array($userPrincipalName) && empty($userPrincipalName))) {
            unset($this->UserPrincipalName);
        } else {
            $this->UserPrincipalName = $userPrincipalName;
        }
        return $this;
    }
    /**
     * Get UserThemeIdentifierForO365Shell value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserThemeIdentifierForO365Shell()
    {
        return isset($this->UserThemeIdentifierForO365Shell) ? $this->UserThemeIdentifierForO365Shell : null;
    }
    /**
     * Set UserThemeIdentifierForO365Shell value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userThemeIdentifierForO365Shell
     * @return \StructType\User
     */
    public function setUserThemeIdentifierForO365Shell($userThemeIdentifierForO365Shell = null)
    {
        // validation for constraint: string
        if (!is_null($userThemeIdentifierForO365Shell) && !is_string($userThemeIdentifierForO365Shell)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userThemeIdentifierForO365Shell)), __LINE__);
        }
        if (is_null($userThemeIdentifierForO365Shell) || (is_array($userThemeIdentifierForO365Shell) && empty($userThemeIdentifierForO365Shell))) {
            unset($this->UserThemeIdentifierForO365Shell);
        } else {
            $this->UserThemeIdentifierForO365Shell = $userThemeIdentifierForO365Shell;
        }
        return $this;
    }
    /**
     * Get UserType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserType()
    {
        return isset($this->UserType) ? $this->UserType : null;
    }
    /**
     * Set UserType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\UserType::valueIsValid()
     * @uses \EnumType\UserType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userType
     * @return \StructType\User
     */
    public function setUserType($userType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UserType::valueIsValid($userType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userType, implode(', ', \EnumType\UserType::getValidValues())), __LINE__);
        }
        if (is_null($userType) || (is_array($userType) && empty($userType))) {
            unset($this->UserType);
        } else {
            $this->UserType = $userType;
        }
        return $this;
    }
    /**
     * Get ValidationStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidationStatus()
    {
        return isset($this->ValidationStatus) ? $this->ValidationStatus : null;
    }
    /**
     * Set ValidationStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ValidationStatus::valueIsValid()
     * @uses \EnumType\ValidationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $validationStatus
     * @return \StructType\User
     */
    public function setValidationStatus($validationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ValidationStatus::valueIsValid($validationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $validationStatus, implode(', ', \EnumType\ValidationStatus::getValidValues())), __LINE__);
        }
        if (is_null($validationStatus) || (is_array($validationStatus) && empty($validationStatus))) {
            unset($this->ValidationStatus);
        } else {
            $this->ValidationStatus = $validationStatus;
        }
        return $this;
    }
    /**
     * Get WhenCreated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWhenCreated()
    {
        return isset($this->WhenCreated) ? $this->WhenCreated : null;
    }
    /**
     * Set WhenCreated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $whenCreated
     * @return \StructType\User
     */
    public function setWhenCreated($whenCreated = null)
    {
        // validation for constraint: string
        if (!is_null($whenCreated) && !is_string($whenCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($whenCreated)), __LINE__);
        }
        if (is_null($whenCreated) || (is_array($whenCreated) && empty($whenCreated))) {
            unset($this->WhenCreated);
        } else {
            $this->WhenCreated = $whenCreated;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\User
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
