<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetDomainAuthenticationRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SetDomainAuthenticationRequest
 * @subpackage Structs
 */
class SetDomainAuthenticationRequest extends Request
{
    /**
     * The Authentication
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Authentication;
    /**
     * The DomainName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DomainName;
    /**
     * The FederationSettings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DomainFederationSettings
     */
    public $FederationSettings;
    /**
     * Constructor method for SetDomainAuthenticationRequest
     * @uses SetDomainAuthenticationRequest::setAuthentication()
     * @uses SetDomainAuthenticationRequest::setDomainName()
     * @uses SetDomainAuthenticationRequest::setFederationSettings()
     * @param string $authentication
     * @param string $domainName
     * @param \StructType\DomainFederationSettings $federationSettings
     */
    public function __construct($authentication = null, $domainName = null, \StructType\DomainFederationSettings $federationSettings = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setDomainName($domainName)
            ->setFederationSettings($federationSettings);
    }
    /**
     * Get Authentication value
     * @return string|null
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @uses \EnumType\DomainAuthenticationType::valueIsValid()
     * @uses \EnumType\DomainAuthenticationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authentication
     * @return \StructType\SetDomainAuthenticationRequest
     */
    public function setAuthentication($authentication = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DomainAuthenticationType::valueIsValid($authentication)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authentication, implode(', ', \EnumType\DomainAuthenticationType::getValidValues())), __LINE__);
        }
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get DomainName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomainName()
    {
        return isset($this->DomainName) ? $this->DomainName : null;
    }
    /**
     * Set DomainName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domainName
     * @return \StructType\SetDomainAuthenticationRequest
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainName)), __LINE__);
        }
        if (is_null($domainName) || (is_array($domainName) && empty($domainName))) {
            unset($this->DomainName);
        } else {
            $this->DomainName = $domainName;
        }
        return $this;
    }
    /**
     * Get FederationSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DomainFederationSettings|null
     */
    public function getFederationSettings()
    {
        return isset($this->FederationSettings) ? $this->FederationSettings : null;
    }
    /**
     * Set FederationSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DomainFederationSettings $federationSettings
     * @return \StructType\SetDomainAuthenticationRequest
     */
    public function setFederationSettings(\StructType\DomainFederationSettings $federationSettings = null)
    {
        if (is_null($federationSettings) || (is_array($federationSettings) && empty($federationSettings))) {
            unset($this->FederationSettings);
        } else {
            $this->FederationSettings = $federationSettings;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetDomainAuthenticationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
