<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetCompanyMultiNationalEnabledRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SetCompanyMultiNationalEnabledRequest
 * @subpackage Structs
 */
class SetCompanyMultiNationalEnabledRequest extends Request
{
    /**
     * The Enable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Enable;
    /**
     * The ServiceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceType;
    /**
     * Constructor method for SetCompanyMultiNationalEnabledRequest
     * @uses SetCompanyMultiNationalEnabledRequest::setEnable()
     * @uses SetCompanyMultiNationalEnabledRequest::setServiceType()
     * @param bool $enable
     * @param string $serviceType
     */
    public function __construct($enable = null, $serviceType = null)
    {
        $this
            ->setEnable($enable)
            ->setServiceType($serviceType);
    }
    /**
     * Get Enable value
     * @return bool|null
     */
    public function getEnable()
    {
        return $this->Enable;
    }
    /**
     * Set Enable value
     * @param bool $enable
     * @return \StructType\SetCompanyMultiNationalEnabledRequest
     */
    public function setEnable($enable = null)
    {
        $this->Enable = $enable;
        return $this;
    }
    /**
     * Get ServiceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceType()
    {
        return isset($this->ServiceType) ? $this->ServiceType : null;
    }
    /**
     * Set ServiceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceType
     * @return \StructType\SetCompanyMultiNationalEnabledRequest
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceType)), __LINE__);
        }
        if (is_null($serviceType) || (is_array($serviceType) && empty($serviceType))) {
            unset($this->ServiceType);
        } else {
            $this->ServiceType = $serviceType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetCompanyMultiNationalEnabledRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
