<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetCompanyDirSyncFeatureRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SetCompanyDirSyncFeatureRequest
 * @subpackage Structs
 */
class SetCompanyDirSyncFeatureRequest extends Request
{
    /**
     * The Enable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Enable;
    /**
     * The Feature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Feature;
    /**
     * Constructor method for SetCompanyDirSyncFeatureRequest
     * @uses SetCompanyDirSyncFeatureRequest::setEnable()
     * @uses SetCompanyDirSyncFeatureRequest::setFeature()
     * @param bool $enable
     * @param string $feature
     */
    public function __construct($enable = null, $feature = null)
    {
        $this
            ->setEnable($enable)
            ->setFeature($feature);
    }
    /**
     * Get Enable value
     * @return bool|null
     */
    public function getEnable()
    {
        return $this->Enable;
    }
    /**
     * Set Enable value
     * @param bool $enable
     * @return \StructType\SetCompanyDirSyncFeatureRequest
     */
    public function setEnable($enable = null)
    {
        $this->Enable = $enable;
        return $this;
    }
    /**
     * Get Feature value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFeature()
    {
        return isset($this->Feature) ? $this->Feature : null;
    }
    /**
     * Set Feature value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $feature
     * @return \StructType\SetCompanyDirSyncFeatureRequest
     */
    public function setFeature($feature = null)
    {
        // validation for constraint: string
        if (!is_null($feature) && !is_string($feature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feature)), __LINE__);
        }
        if (is_null($feature) || (is_array($feature) && empty($feature))) {
            unset($this->Feature);
        } else {
            $this->Feature = $feature;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetCompanyDirSyncFeatureRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
