<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServicePlan StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ServicePlan
 * @subpackage Structs
 */
class ServicePlan extends AbstractStructBase
{
    /**
     * The ServiceName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceName;
    /**
     * The ServicePlanId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ServicePlanId;
    /**
     * The ServiceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceType;
    /**
     * The TargetClass
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TargetClass;
    /**
     * Constructor method for ServicePlan
     * @uses ServicePlan::setServiceName()
     * @uses ServicePlan::setServicePlanId()
     * @uses ServicePlan::setServiceType()
     * @uses ServicePlan::setTargetClass()
     * @param string $serviceName
     * @param string $servicePlanId
     * @param string $serviceType
     * @param string $targetClass
     */
    public function __construct($serviceName = null, $servicePlanId = null, $serviceType = null, $targetClass = null)
    {
        $this
            ->setServiceName($serviceName)
            ->setServicePlanId($servicePlanId)
            ->setServiceType($serviceType)
            ->setTargetClass($targetClass);
    }
    /**
     * Get ServiceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceName()
    {
        return isset($this->ServiceName) ? $this->ServiceName : null;
    }
    /**
     * Set ServiceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceName
     * @return \StructType\ServicePlan
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceName)), __LINE__);
        }
        if (is_null($serviceName) || (is_array($serviceName) && empty($serviceName))) {
            unset($this->ServiceName);
        } else {
            $this->ServiceName = $serviceName;
        }
        return $this;
    }
    /**
     * Get ServicePlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServicePlanId()
    {
        return isset($this->ServicePlanId) ? $this->ServicePlanId : null;
    }
    /**
     * Set ServicePlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $servicePlanId
     * @return \StructType\ServicePlan
     */
    public function setServicePlanId($servicePlanId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($servicePlanId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $servicePlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($servicePlanId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($servicePlanId) && !is_string($servicePlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicePlanId)), __LINE__);
        }
        if (is_null($servicePlanId) || (is_array($servicePlanId) && empty($servicePlanId))) {
            unset($this->ServicePlanId);
        } else {
            $this->ServicePlanId = $servicePlanId;
        }
        return $this;
    }
    /**
     * Get ServiceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceType()
    {
        return isset($this->ServiceType) ? $this->ServiceType : null;
    }
    /**
     * Set ServiceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceType
     * @return \StructType\ServicePlan
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceType)), __LINE__);
        }
        if (is_null($serviceType) || (is_array($serviceType) && empty($serviceType))) {
            unset($this->ServiceType);
        } else {
            $this->ServiceType = $serviceType;
        }
        return $this;
    }
    /**
     * Get TargetClass value
     * @return string|null
     */
    public function getTargetClass()
    {
        return $this->TargetClass;
    }
    /**
     * Set TargetClass value
     * @uses \EnumType\SkuTargetClass::valueIsValid()
     * @uses \EnumType\SkuTargetClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $targetClass
     * @return \StructType\ServicePlan
     */
    public function setTargetClass($targetClass = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SkuTargetClass::valueIsValid($targetClass)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $targetClass, implode(', ', \EnumType\SkuTargetClass::getValidValues())), __LINE__);
        }
        $this->TargetClass = $targetClass;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServicePlan
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
