<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoleMemberSearchDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RoleMemberSearchDefinition
 * @subpackage Structs
 */
class RoleMemberSearchDefinition extends SearchDefinition
{
    /**
     * The IncludedProperties
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $IncludedProperties;
    /**
     * The MemberObjectTypes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $MemberObjectTypes;
    /**
     * The RoleObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoleObjectId;
    /**
     * Constructor method for RoleMemberSearchDefinition
     * @uses RoleMemberSearchDefinition::setIncludedProperties()
     * @uses RoleMemberSearchDefinition::setMemberObjectTypes()
     * @uses RoleMemberSearchDefinition::setRoleObjectId()
     * @param \ArrayType\ArrayOfstring $includedProperties
     * @param \ArrayType\ArrayOfstring $memberObjectTypes
     * @param string $roleObjectId
     */
    public function __construct(\ArrayType\ArrayOfstring $includedProperties = null, \ArrayType\ArrayOfstring $memberObjectTypes = null, $roleObjectId = null)
    {
        $this
            ->setIncludedProperties($includedProperties)
            ->setMemberObjectTypes($memberObjectTypes)
            ->setRoleObjectId($roleObjectId);
    }
    /**
     * Get IncludedProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getIncludedProperties()
    {
        return isset($this->IncludedProperties) ? $this->IncludedProperties : null;
    }
    /**
     * Set IncludedProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $includedProperties
     * @return \StructType\RoleMemberSearchDefinition
     */
    public function setIncludedProperties(\ArrayType\ArrayOfstring $includedProperties = null)
    {
        if (is_null($includedProperties) || (is_array($includedProperties) && empty($includedProperties))) {
            unset($this->IncludedProperties);
        } else {
            $this->IncludedProperties = $includedProperties;
        }
        return $this;
    }
    /**
     * Get MemberObjectTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getMemberObjectTypes()
    {
        return isset($this->MemberObjectTypes) ? $this->MemberObjectTypes : null;
    }
    /**
     * Set MemberObjectTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $memberObjectTypes
     * @return \StructType\RoleMemberSearchDefinition
     */
    public function setMemberObjectTypes(\ArrayType\ArrayOfstring $memberObjectTypes = null)
    {
        if (is_null($memberObjectTypes) || (is_array($memberObjectTypes) && empty($memberObjectTypes))) {
            unset($this->MemberObjectTypes);
        } else {
            $this->MemberObjectTypes = $memberObjectTypes;
        }
        return $this;
    }
    /**
     * Get RoleObjectId value
     * @return string|null
     */
    public function getRoleObjectId()
    {
        return $this->RoleObjectId;
    }
    /**
     * Set RoleObjectId value
     * @param string $roleObjectId
     * @return \StructType\RoleMemberSearchDefinition
     */
    public function setRoleObjectId($roleObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($roleObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $roleObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($roleObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($roleObjectId) && !is_string($roleObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roleObjectId)), __LINE__);
        }
        $this->RoleObjectId = $roleObjectId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoleMemberSearchDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
