<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartnerInformation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PartnerInformation
 * @subpackage Structs
 */
class PartnerInformation extends AbstractStructBase
{
    /**
     * The CompanyType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyType;
    /**
     * The Contracts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfguid
     */
    public $Contracts;
    /**
     * The DapEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DapEnabled;
    /**
     * The ObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObjectId;
    /**
     * The PartnerCommerceUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PartnerCommerceUrl;
    /**
     * The PartnerCompanyName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PartnerCompanyName;
    /**
     * The PartnerContracts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPartnerContract
     */
    public $PartnerContracts;
    /**
     * The PartnerHelpUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PartnerHelpUrl;
    /**
     * The PartnerRoleMap
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPartnerRoleMapEntry
     */
    public $PartnerRoleMap;
    /**
     * The PartnerSupportEmails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $PartnerSupportEmails;
    /**
     * The PartnerSupportTelephones
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $PartnerSupportTelephones;
    /**
     * The PartnerSupportUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PartnerSupportUrl;
    /**
     * Constructor method for PartnerInformation
     * @uses PartnerInformation::setCompanyType()
     * @uses PartnerInformation::setContracts()
     * @uses PartnerInformation::setDapEnabled()
     * @uses PartnerInformation::setObjectId()
     * @uses PartnerInformation::setPartnerCommerceUrl()
     * @uses PartnerInformation::setPartnerCompanyName()
     * @uses PartnerInformation::setPartnerContracts()
     * @uses PartnerInformation::setPartnerHelpUrl()
     * @uses PartnerInformation::setPartnerRoleMap()
     * @uses PartnerInformation::setPartnerSupportEmails()
     * @uses PartnerInformation::setPartnerSupportTelephones()
     * @uses PartnerInformation::setPartnerSupportUrl()
     * @param string $companyType
     * @param \ArrayType\ArrayOfguid $contracts
     * @param bool $dapEnabled
     * @param string $objectId
     * @param string $partnerCommerceUrl
     * @param string $partnerCompanyName
     * @param \ArrayType\ArrayOfPartnerContract $partnerContracts
     * @param string $partnerHelpUrl
     * @param \ArrayType\ArrayOfPartnerRoleMapEntry $partnerRoleMap
     * @param \ArrayType\ArrayOfstring $partnerSupportEmails
     * @param \ArrayType\ArrayOfstring $partnerSupportTelephones
     * @param string $partnerSupportUrl
     */
    public function __construct($companyType = null, \ArrayType\ArrayOfguid $contracts = null, $dapEnabled = null, $objectId = null, $partnerCommerceUrl = null, $partnerCompanyName = null, \ArrayType\ArrayOfPartnerContract $partnerContracts = null, $partnerHelpUrl = null, \ArrayType\ArrayOfPartnerRoleMapEntry $partnerRoleMap = null, \ArrayType\ArrayOfstring $partnerSupportEmails = null, \ArrayType\ArrayOfstring $partnerSupportTelephones = null, $partnerSupportUrl = null)
    {
        $this
            ->setCompanyType($companyType)
            ->setContracts($contracts)
            ->setDapEnabled($dapEnabled)
            ->setObjectId($objectId)
            ->setPartnerCommerceUrl($partnerCommerceUrl)
            ->setPartnerCompanyName($partnerCompanyName)
            ->setPartnerContracts($partnerContracts)
            ->setPartnerHelpUrl($partnerHelpUrl)
            ->setPartnerRoleMap($partnerRoleMap)
            ->setPartnerSupportEmails($partnerSupportEmails)
            ->setPartnerSupportTelephones($partnerSupportTelephones)
            ->setPartnerSupportUrl($partnerSupportUrl);
    }
    /**
     * Get CompanyType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyType()
    {
        return isset($this->CompanyType) ? $this->CompanyType : null;
    }
    /**
     * Set CompanyType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CompanyType::valueIsValid()
     * @uses \EnumType\CompanyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $companyType
     * @return \StructType\PartnerInformation
     */
    public function setCompanyType($companyType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CompanyType::valueIsValid($companyType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $companyType, implode(', ', \EnumType\CompanyType::getValidValues())), __LINE__);
        }
        if (is_null($companyType) || (is_array($companyType) && empty($companyType))) {
            unset($this->CompanyType);
        } else {
            $this->CompanyType = $companyType;
        }
        return $this;
    }
    /**
     * Get Contracts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfguid|null
     */
    public function getContracts()
    {
        return isset($this->Contracts) ? $this->Contracts : null;
    }
    /**
     * Set Contracts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfguid $contracts
     * @return \StructType\PartnerInformation
     */
    public function setContracts(\ArrayType\ArrayOfguid $contracts = null)
    {
        if (is_null($contracts) || (is_array($contracts) && empty($contracts))) {
            unset($this->Contracts);
        } else {
            $this->Contracts = $contracts;
        }
        return $this;
    }
    /**
     * Get DapEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDapEnabled()
    {
        return isset($this->DapEnabled) ? $this->DapEnabled : null;
    }
    /**
     * Set DapEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $dapEnabled
     * @return \StructType\PartnerInformation
     */
    public function setDapEnabled($dapEnabled = null)
    {
        if (is_null($dapEnabled) || (is_array($dapEnabled) && empty($dapEnabled))) {
            unset($this->DapEnabled);
        } else {
            $this->DapEnabled = $dapEnabled;
        }
        return $this;
    }
    /**
     * Get ObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObjectId()
    {
        return isset($this->ObjectId) ? $this->ObjectId : null;
    }
    /**
     * Set ObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $objectId
     * @return \StructType\PartnerInformation
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($objectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($objectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectId)), __LINE__);
        }
        if (is_null($objectId) || (is_array($objectId) && empty($objectId))) {
            unset($this->ObjectId);
        } else {
            $this->ObjectId = $objectId;
        }
        return $this;
    }
    /**
     * Get PartnerCommerceUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartnerCommerceUrl()
    {
        return isset($this->PartnerCommerceUrl) ? $this->PartnerCommerceUrl : null;
    }
    /**
     * Set PartnerCommerceUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partnerCommerceUrl
     * @return \StructType\PartnerInformation
     */
    public function setPartnerCommerceUrl($partnerCommerceUrl = null)
    {
        // validation for constraint: string
        if (!is_null($partnerCommerceUrl) && !is_string($partnerCommerceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partnerCommerceUrl)), __LINE__);
        }
        if (is_null($partnerCommerceUrl) || (is_array($partnerCommerceUrl) && empty($partnerCommerceUrl))) {
            unset($this->PartnerCommerceUrl);
        } else {
            $this->PartnerCommerceUrl = $partnerCommerceUrl;
        }
        return $this;
    }
    /**
     * Get PartnerCompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartnerCompanyName()
    {
        return isset($this->PartnerCompanyName) ? $this->PartnerCompanyName : null;
    }
    /**
     * Set PartnerCompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partnerCompanyName
     * @return \StructType\PartnerInformation
     */
    public function setPartnerCompanyName($partnerCompanyName = null)
    {
        // validation for constraint: string
        if (!is_null($partnerCompanyName) && !is_string($partnerCompanyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partnerCompanyName)), __LINE__);
        }
        if (is_null($partnerCompanyName) || (is_array($partnerCompanyName) && empty($partnerCompanyName))) {
            unset($this->PartnerCompanyName);
        } else {
            $this->PartnerCompanyName = $partnerCompanyName;
        }
        return $this;
    }
    /**
     * Get PartnerContracts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPartnerContract|null
     */
    public function getPartnerContracts()
    {
        return isset($this->PartnerContracts) ? $this->PartnerContracts : null;
    }
    /**
     * Set PartnerContracts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPartnerContract $partnerContracts
     * @return \StructType\PartnerInformation
     */
    public function setPartnerContracts(\ArrayType\ArrayOfPartnerContract $partnerContracts = null)
    {
        if (is_null($partnerContracts) || (is_array($partnerContracts) && empty($partnerContracts))) {
            unset($this->PartnerContracts);
        } else {
            $this->PartnerContracts = $partnerContracts;
        }
        return $this;
    }
    /**
     * Get PartnerHelpUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartnerHelpUrl()
    {
        return isset($this->PartnerHelpUrl) ? $this->PartnerHelpUrl : null;
    }
    /**
     * Set PartnerHelpUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partnerHelpUrl
     * @return \StructType\PartnerInformation
     */
    public function setPartnerHelpUrl($partnerHelpUrl = null)
    {
        // validation for constraint: string
        if (!is_null($partnerHelpUrl) && !is_string($partnerHelpUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partnerHelpUrl)), __LINE__);
        }
        if (is_null($partnerHelpUrl) || (is_array($partnerHelpUrl) && empty($partnerHelpUrl))) {
            unset($this->PartnerHelpUrl);
        } else {
            $this->PartnerHelpUrl = $partnerHelpUrl;
        }
        return $this;
    }
    /**
     * Get PartnerRoleMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPartnerRoleMapEntry|null
     */
    public function getPartnerRoleMap()
    {
        return isset($this->PartnerRoleMap) ? $this->PartnerRoleMap : null;
    }
    /**
     * Set PartnerRoleMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPartnerRoleMapEntry $partnerRoleMap
     * @return \StructType\PartnerInformation
     */
    public function setPartnerRoleMap(\ArrayType\ArrayOfPartnerRoleMapEntry $partnerRoleMap = null)
    {
        if (is_null($partnerRoleMap) || (is_array($partnerRoleMap) && empty($partnerRoleMap))) {
            unset($this->PartnerRoleMap);
        } else {
            $this->PartnerRoleMap = $partnerRoleMap;
        }
        return $this;
    }
    /**
     * Get PartnerSupportEmails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getPartnerSupportEmails()
    {
        return isset($this->PartnerSupportEmails) ? $this->PartnerSupportEmails : null;
    }
    /**
     * Set PartnerSupportEmails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $partnerSupportEmails
     * @return \StructType\PartnerInformation
     */
    public function setPartnerSupportEmails(\ArrayType\ArrayOfstring $partnerSupportEmails = null)
    {
        if (is_null($partnerSupportEmails) || (is_array($partnerSupportEmails) && empty($partnerSupportEmails))) {
            unset($this->PartnerSupportEmails);
        } else {
            $this->PartnerSupportEmails = $partnerSupportEmails;
        }
        return $this;
    }
    /**
     * Get PartnerSupportTelephones value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getPartnerSupportTelephones()
    {
        return isset($this->PartnerSupportTelephones) ? $this->PartnerSupportTelephones : null;
    }
    /**
     * Set PartnerSupportTelephones value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $partnerSupportTelephones
     * @return \StructType\PartnerInformation
     */
    public function setPartnerSupportTelephones(\ArrayType\ArrayOfstring $partnerSupportTelephones = null)
    {
        if (is_null($partnerSupportTelephones) || (is_array($partnerSupportTelephones) && empty($partnerSupportTelephones))) {
            unset($this->PartnerSupportTelephones);
        } else {
            $this->PartnerSupportTelephones = $partnerSupportTelephones;
        }
        return $this;
    }
    /**
     * Get PartnerSupportUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartnerSupportUrl()
    {
        return isset($this->PartnerSupportUrl) ? $this->PartnerSupportUrl : null;
    }
    /**
     * Set PartnerSupportUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partnerSupportUrl
     * @return \StructType\PartnerInformation
     */
    public function setPartnerSupportUrl($partnerSupportUrl = null)
    {
        // validation for constraint: string
        if (!is_null($partnerSupportUrl) && !is_string($partnerSupportUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partnerSupportUrl)), __LINE__);
        }
        if (is_null($partnerSupportUrl) || (is_array($partnerSupportUrl) && empty($partnerSupportUrl))) {
            unset($this->PartnerSupportUrl);
        } else {
            $this->PartnerSupportUrl = $partnerSupportUrl;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PartnerInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
