<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartnerContract StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PartnerContract
 * @subpackage Structs
 */
class PartnerContract extends AbstractStructBase
{
    /**
     * The ContractType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContractType;
    /**
     * The DefaultDomainName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultDomainName;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The ObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObjectId;
    /**
     * The PartnerContext
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PartnerContext;
    /**
     * The TenantId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TenantId;
    /**
     * Constructor method for PartnerContract
     * @uses PartnerContract::setContractType()
     * @uses PartnerContract::setDefaultDomainName()
     * @uses PartnerContract::setName()
     * @uses PartnerContract::setObjectId()
     * @uses PartnerContract::setPartnerContext()
     * @uses PartnerContract::setTenantId()
     * @param string $contractType
     * @param string $defaultDomainName
     * @param string $name
     * @param string $objectId
     * @param string $partnerContext
     * @param string $tenantId
     */
    public function __construct($contractType = null, $defaultDomainName = null, $name = null, $objectId = null, $partnerContext = null, $tenantId = null)
    {
        $this
            ->setContractType($contractType)
            ->setDefaultDomainName($defaultDomainName)
            ->setName($name)
            ->setObjectId($objectId)
            ->setPartnerContext($partnerContext)
            ->setTenantId($tenantId);
    }
    /**
     * Get ContractType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractType()
    {
        return isset($this->ContractType) ? $this->ContractType : null;
    }
    /**
     * Set ContractType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ContractType::valueIsValid()
     * @uses \EnumType\ContractType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contractType
     * @return \StructType\PartnerContract
     */
    public function setContractType($contractType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContractType::valueIsValid($contractType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $contractType, implode(', ', \EnumType\ContractType::getValidValues())), __LINE__);
        }
        if (is_null($contractType) || (is_array($contractType) && empty($contractType))) {
            unset($this->ContractType);
        } else {
            $this->ContractType = $contractType;
        }
        return $this;
    }
    /**
     * Get DefaultDomainName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultDomainName()
    {
        return isset($this->DefaultDomainName) ? $this->DefaultDomainName : null;
    }
    /**
     * Set DefaultDomainName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultDomainName
     * @return \StructType\PartnerContract
     */
    public function setDefaultDomainName($defaultDomainName = null)
    {
        // validation for constraint: string
        if (!is_null($defaultDomainName) && !is_string($defaultDomainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultDomainName)), __LINE__);
        }
        if (is_null($defaultDomainName) || (is_array($defaultDomainName) && empty($defaultDomainName))) {
            unset($this->DefaultDomainName);
        } else {
            $this->DefaultDomainName = $defaultDomainName;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\PartnerContract
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get ObjectId value
     * @return string|null
     */
    public function getObjectId()
    {
        return $this->ObjectId;
    }
    /**
     * Set ObjectId value
     * @param string $objectId
     * @return \StructType\PartnerContract
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($objectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($objectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectId)), __LINE__);
        }
        $this->ObjectId = $objectId;
        return $this;
    }
    /**
     * Get PartnerContext value
     * @return string|null
     */
    public function getPartnerContext()
    {
        return $this->PartnerContext;
    }
    /**
     * Set PartnerContext value
     * @param string $partnerContext
     * @return \StructType\PartnerContract
     */
    public function setPartnerContext($partnerContext = null)
    {
        // validation for constraint: pattern
        if (is_scalar($partnerContext) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $partnerContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($partnerContext, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($partnerContext) && !is_string($partnerContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partnerContext)), __LINE__);
        }
        $this->PartnerContext = $partnerContext;
        return $this;
    }
    /**
     * Get TenantId value
     * @return string|null
     */
    public function getTenantId()
    {
        return $this->TenantId;
    }
    /**
     * Set TenantId value
     * @param string $tenantId
     * @return \StructType\PartnerContract
     */
    public function setTenantId($tenantId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($tenantId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $tenantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($tenantId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tenantId) && !is_string($tenantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tenantId)), __LINE__);
        }
        $this->TenantId = $tenantId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PartnerContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
