<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListServicePrincipalCredentialsBySpnRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ListServicePrincipalCredentialsBySpnRequest
 * @subpackage Structs
 */
class ListServicePrincipalCredentialsBySpnRequest extends Request
{
    /**
     * The ReturnKeyValues
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReturnKeyValues;
    /**
     * The ServicePrincipalName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServicePrincipalName;
    /**
     * Constructor method for ListServicePrincipalCredentialsBySpnRequest
     * @uses ListServicePrincipalCredentialsBySpnRequest::setReturnKeyValues()
     * @uses ListServicePrincipalCredentialsBySpnRequest::setServicePrincipalName()
     * @param bool $returnKeyValues
     * @param string $servicePrincipalName
     */
    public function __construct($returnKeyValues = null, $servicePrincipalName = null)
    {
        $this
            ->setReturnKeyValues($returnKeyValues)
            ->setServicePrincipalName($servicePrincipalName);
    }
    /**
     * Get ReturnKeyValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReturnKeyValues()
    {
        return isset($this->ReturnKeyValues) ? $this->ReturnKeyValues : null;
    }
    /**
     * Set ReturnKeyValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $returnKeyValues
     * @return \StructType\ListServicePrincipalCredentialsBySpnRequest
     */
    public function setReturnKeyValues($returnKeyValues = null)
    {
        if (is_null($returnKeyValues) || (is_array($returnKeyValues) && empty($returnKeyValues))) {
            unset($this->ReturnKeyValues);
        } else {
            $this->ReturnKeyValues = $returnKeyValues;
        }
        return $this;
    }
    /**
     * Get ServicePrincipalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServicePrincipalName()
    {
        return isset($this->ServicePrincipalName) ? $this->ServicePrincipalName : null;
    }
    /**
     * Set ServicePrincipalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $servicePrincipalName
     * @return \StructType\ListServicePrincipalCredentialsBySpnRequest
     */
    public function setServicePrincipalName($servicePrincipalName = null)
    {
        // validation for constraint: string
        if (!is_null($servicePrincipalName) && !is_string($servicePrincipalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicePrincipalName)), __LINE__);
        }
        if (is_null($servicePrincipalName) || (is_array($servicePrincipalName) && empty($servicePrincipalName))) {
            unset($this->ServicePrincipalName);
        } else {
            $this->ServicePrincipalName = $servicePrincipalName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ListServicePrincipalCredentialsBySpnRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
