<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LicenseAssignmentDetail StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LicenseAssignmentDetail
 * @subpackage Structs
 */
class LicenseAssignmentDetail extends AbstractStructBase
{
    /**
     * The AccountSku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountSkuIdentifier
     */
    public $AccountSku;
    /**
     * The Assignments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLicenseAssignment
     */
    public $Assignments;
    /**
     * Constructor method for LicenseAssignmentDetail
     * @uses LicenseAssignmentDetail::setAccountSku()
     * @uses LicenseAssignmentDetail::setAssignments()
     * @param \StructType\AccountSkuIdentifier $accountSku
     * @param \ArrayType\ArrayOfLicenseAssignment $assignments
     */
    public function __construct(\StructType\AccountSkuIdentifier $accountSku = null, \ArrayType\ArrayOfLicenseAssignment $assignments = null)
    {
        $this
            ->setAccountSku($accountSku)
            ->setAssignments($assignments);
    }
    /**
     * Get AccountSku value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountSkuIdentifier|null
     */
    public function getAccountSku()
    {
        return isset($this->AccountSku) ? $this->AccountSku : null;
    }
    /**
     * Set AccountSku value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AccountSkuIdentifier $accountSku
     * @return \StructType\LicenseAssignmentDetail
     */
    public function setAccountSku(\StructType\AccountSkuIdentifier $accountSku = null)
    {
        if (is_null($accountSku) || (is_array($accountSku) && empty($accountSku))) {
            unset($this->AccountSku);
        } else {
            $this->AccountSku = $accountSku;
        }
        return $this;
    }
    /**
     * Get Assignments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLicenseAssignment|null
     */
    public function getAssignments()
    {
        return isset($this->Assignments) ? $this->Assignments : null;
    }
    /**
     * Set Assignments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLicenseAssignment $assignments
     * @return \StructType\LicenseAssignmentDetail
     */
    public function setAssignments(\ArrayType\ArrayOfLicenseAssignment $assignments = null)
    {
        if (is_null($assignments) || (is_array($assignments) && empty($assignments))) {
            unset($this->Assignments);
        } else {
            $this->Assignments = $assignments;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LicenseAssignmentDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
