<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvalidSubscriptionStatusException StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:InvalidSubscriptionStatusException
 * @subpackage Structs
 */
class InvalidSubscriptionStatusException extends InvalidUserLicenseException
{
    /**
     * The SubscriptionStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionStatus;
    /**
     * Constructor method for InvalidSubscriptionStatusException
     * @uses InvalidSubscriptionStatusException::setSubscriptionStatus()
     * @param string $subscriptionStatus
     */
    public function __construct($subscriptionStatus = null)
    {
        $this
            ->setSubscriptionStatus($subscriptionStatus);
    }
    /**
     * Get SubscriptionStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionStatus()
    {
        return isset($this->SubscriptionStatus) ? $this->SubscriptionStatus : null;
    }
    /**
     * Set SubscriptionStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\SubscriptionStatus::valueIsValid()
     * @uses \EnumType\SubscriptionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriptionStatus
     * @return \StructType\InvalidSubscriptionStatusException
     */
    public function setSubscriptionStatus($subscriptionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SubscriptionStatus::valueIsValid($subscriptionStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subscriptionStatus, implode(', ', \EnumType\SubscriptionStatus::getValidValues())), __LINE__);
        }
        if (is_null($subscriptionStatus) || (is_array($subscriptionStatus) && empty($subscriptionStatus))) {
            unset($this->SubscriptionStatus);
        } else {
            $this->SubscriptionStatus = $subscriptionStatus;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvalidSubscriptionStatusException
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
