<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupSearchDefinition StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GroupSearchDefinition
 * @subpackage Structs
 */
class GroupSearchDefinition extends SearchDefinition
{
    /**
     * The AccountSku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountSkuIdentifier
     */
    public $AccountSku;
    /**
     * The GroupType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupType;
    /**
     * The HasErrorsOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasErrorsOnly;
    /**
     * The HasLicenseErrorsOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasLicenseErrorsOnly;
    /**
     * The IncludedProperties
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $IncludedProperties;
    /**
     * The IsAgentRole
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAgentRole;
    /**
     * The UserObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserObjectId;
    /**
     * The UserPrincipalName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserPrincipalName;
    /**
     * Constructor method for GroupSearchDefinition
     * @uses GroupSearchDefinition::setAccountSku()
     * @uses GroupSearchDefinition::setGroupType()
     * @uses GroupSearchDefinition::setHasErrorsOnly()
     * @uses GroupSearchDefinition::setHasLicenseErrorsOnly()
     * @uses GroupSearchDefinition::setIncludedProperties()
     * @uses GroupSearchDefinition::setIsAgentRole()
     * @uses GroupSearchDefinition::setUserObjectId()
     * @uses GroupSearchDefinition::setUserPrincipalName()
     * @param \StructType\AccountSkuIdentifier $accountSku
     * @param string $groupType
     * @param bool $hasErrorsOnly
     * @param bool $hasLicenseErrorsOnly
     * @param \ArrayType\ArrayOfstring $includedProperties
     * @param bool $isAgentRole
     * @param string $userObjectId
     * @param string $userPrincipalName
     */
    public function __construct(\StructType\AccountSkuIdentifier $accountSku = null, $groupType = null, $hasErrorsOnly = null, $hasLicenseErrorsOnly = null, \ArrayType\ArrayOfstring $includedProperties = null, $isAgentRole = null, $userObjectId = null, $userPrincipalName = null)
    {
        $this
            ->setAccountSku($accountSku)
            ->setGroupType($groupType)
            ->setHasErrorsOnly($hasErrorsOnly)
            ->setHasLicenseErrorsOnly($hasLicenseErrorsOnly)
            ->setIncludedProperties($includedProperties)
            ->setIsAgentRole($isAgentRole)
            ->setUserObjectId($userObjectId)
            ->setUserPrincipalName($userPrincipalName);
    }
    /**
     * Get AccountSku value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountSkuIdentifier|null
     */
    public function getAccountSku()
    {
        return isset($this->AccountSku) ? $this->AccountSku : null;
    }
    /**
     * Set AccountSku value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AccountSkuIdentifier $accountSku
     * @return \StructType\GroupSearchDefinition
     */
    public function setAccountSku(\StructType\AccountSkuIdentifier $accountSku = null)
    {
        if (is_null($accountSku) || (is_array($accountSku) && empty($accountSku))) {
            unset($this->AccountSku);
        } else {
            $this->AccountSku = $accountSku;
        }
        return $this;
    }
    /**
     * Get GroupType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupType()
    {
        return isset($this->GroupType) ? $this->GroupType : null;
    }
    /**
     * Set GroupType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\GroupType::valueIsValid()
     * @uses \EnumType\GroupType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $groupType
     * @return \StructType\GroupSearchDefinition
     */
    public function setGroupType($groupType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GroupType::valueIsValid($groupType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $groupType, implode(', ', \EnumType\GroupType::getValidValues())), __LINE__);
        }
        if (is_null($groupType) || (is_array($groupType) && empty($groupType))) {
            unset($this->GroupType);
        } else {
            $this->GroupType = $groupType;
        }
        return $this;
    }
    /**
     * Get HasErrorsOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasErrorsOnly()
    {
        return isset($this->HasErrorsOnly) ? $this->HasErrorsOnly : null;
    }
    /**
     * Set HasErrorsOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasErrorsOnly
     * @return \StructType\GroupSearchDefinition
     */
    public function setHasErrorsOnly($hasErrorsOnly = null)
    {
        if (is_null($hasErrorsOnly) || (is_array($hasErrorsOnly) && empty($hasErrorsOnly))) {
            unset($this->HasErrorsOnly);
        } else {
            $this->HasErrorsOnly = $hasErrorsOnly;
        }
        return $this;
    }
    /**
     * Get HasLicenseErrorsOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasLicenseErrorsOnly()
    {
        return isset($this->HasLicenseErrorsOnly) ? $this->HasLicenseErrorsOnly : null;
    }
    /**
     * Set HasLicenseErrorsOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasLicenseErrorsOnly
     * @return \StructType\GroupSearchDefinition
     */
    public function setHasLicenseErrorsOnly($hasLicenseErrorsOnly = null)
    {
        if (is_null($hasLicenseErrorsOnly) || (is_array($hasLicenseErrorsOnly) && empty($hasLicenseErrorsOnly))) {
            unset($this->HasLicenseErrorsOnly);
        } else {
            $this->HasLicenseErrorsOnly = $hasLicenseErrorsOnly;
        }
        return $this;
    }
    /**
     * Get IncludedProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getIncludedProperties()
    {
        return isset($this->IncludedProperties) ? $this->IncludedProperties : null;
    }
    /**
     * Set IncludedProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $includedProperties
     * @return \StructType\GroupSearchDefinition
     */
    public function setIncludedProperties(\ArrayType\ArrayOfstring $includedProperties = null)
    {
        if (is_null($includedProperties) || (is_array($includedProperties) && empty($includedProperties))) {
            unset($this->IncludedProperties);
        } else {
            $this->IncludedProperties = $includedProperties;
        }
        return $this;
    }
    /**
     * Get IsAgentRole value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAgentRole()
    {
        return isset($this->IsAgentRole) ? $this->IsAgentRole : null;
    }
    /**
     * Set IsAgentRole value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAgentRole
     * @return \StructType\GroupSearchDefinition
     */
    public function setIsAgentRole($isAgentRole = null)
    {
        if (is_null($isAgentRole) || (is_array($isAgentRole) && empty($isAgentRole))) {
            unset($this->IsAgentRole);
        } else {
            $this->IsAgentRole = $isAgentRole;
        }
        return $this;
    }
    /**
     * Get UserObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserObjectId()
    {
        return isset($this->UserObjectId) ? $this->UserObjectId : null;
    }
    /**
     * Set UserObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userObjectId
     * @return \StructType\GroupSearchDefinition
     */
    public function setUserObjectId($userObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($userObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $userObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($userObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($userObjectId) && !is_string($userObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userObjectId)), __LINE__);
        }
        if (is_null($userObjectId) || (is_array($userObjectId) && empty($userObjectId))) {
            unset($this->UserObjectId);
        } else {
            $this->UserObjectId = $userObjectId;
        }
        return $this;
    }
    /**
     * Get UserPrincipalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserPrincipalName()
    {
        return isset($this->UserPrincipalName) ? $this->UserPrincipalName : null;
    }
    /**
     * Set UserPrincipalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userPrincipalName
     * @return \StructType\GroupSearchDefinition
     */
    public function setUserPrincipalName($userPrincipalName = null)
    {
        // validation for constraint: string
        if (!is_null($userPrincipalName) && !is_string($userPrincipalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userPrincipalName)), __LINE__);
        }
        if (is_null($userPrincipalName) || (is_array($userPrincipalName) && empty($userPrincipalName))) {
            unset($this->UserPrincipalName);
        } else {
            $this->UserPrincipalName = $userPrincipalName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupSearchDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
