<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Group StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Group
 * @subpackage Structs
 */
class Group extends AbstractStructBase
{
    /**
     * The AssignedLicenses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAssignedLicense
     */
    public $AssignedLicenses;
    /**
     * The CommonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommonName;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The DirSyncProvisioningErrors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDirSyncProvisioningError
     */
    public $DirSyncProvisioningErrors;
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailAddress;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfValidationError
     */
    public $Errors;
    /**
     * The GroupLicenseProcessingDetail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GroupLicenseProcessingDetail
     */
    public $GroupLicenseProcessingDetail;
    /**
     * The GroupType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupType;
    /**
     * The IsSystem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The LastDirSyncTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastDirSyncTime;
    /**
     * The Licenses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAccountSkuIdentifier
     */
    public $Licenses;
    /**
     * The ManagedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ManagedBy;
    /**
     * The ObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObjectId;
    /**
     * The ProxyAddresses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $ProxyAddresses;
    /**
     * The ValidationStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidationStatus;
    /**
     * Constructor method for Group
     * @uses Group::setAssignedLicenses()
     * @uses Group::setCommonName()
     * @uses Group::setDescription()
     * @uses Group::setDirSyncProvisioningErrors()
     * @uses Group::setDisplayName()
     * @uses Group::setEmailAddress()
     * @uses Group::setErrors()
     * @uses Group::setGroupLicenseProcessingDetail()
     * @uses Group::setGroupType()
     * @uses Group::setIsSystem()
     * @uses Group::setLastDirSyncTime()
     * @uses Group::setLicenses()
     * @uses Group::setManagedBy()
     * @uses Group::setObjectId()
     * @uses Group::setProxyAddresses()
     * @uses Group::setValidationStatus()
     * @param \ArrayType\ArrayOfAssignedLicense $assignedLicenses
     * @param string $commonName
     * @param string $description
     * @param \ArrayType\ArrayOfDirSyncProvisioningError $dirSyncProvisioningErrors
     * @param string $displayName
     * @param string $emailAddress
     * @param \ArrayType\ArrayOfValidationError $errors
     * @param \StructType\GroupLicenseProcessingDetail $groupLicenseProcessingDetail
     * @param string $groupType
     * @param bool $isSystem
     * @param string $lastDirSyncTime
     * @param \ArrayType\ArrayOfAccountSkuIdentifier $licenses
     * @param string $managedBy
     * @param string $objectId
     * @param \ArrayType\ArrayOfstring $proxyAddresses
     * @param string $validationStatus
     */
    public function __construct(\ArrayType\ArrayOfAssignedLicense $assignedLicenses = null, $commonName = null, $description = null, \ArrayType\ArrayOfDirSyncProvisioningError $dirSyncProvisioningErrors = null, $displayName = null, $emailAddress = null, \ArrayType\ArrayOfValidationError $errors = null, \StructType\GroupLicenseProcessingDetail $groupLicenseProcessingDetail = null, $groupType = null, $isSystem = null, $lastDirSyncTime = null, \ArrayType\ArrayOfAccountSkuIdentifier $licenses = null, $managedBy = null, $objectId = null, \ArrayType\ArrayOfstring $proxyAddresses = null, $validationStatus = null)
    {
        $this
            ->setAssignedLicenses($assignedLicenses)
            ->setCommonName($commonName)
            ->setDescription($description)
            ->setDirSyncProvisioningErrors($dirSyncProvisioningErrors)
            ->setDisplayName($displayName)
            ->setEmailAddress($emailAddress)
            ->setErrors($errors)
            ->setGroupLicenseProcessingDetail($groupLicenseProcessingDetail)
            ->setGroupType($groupType)
            ->setIsSystem($isSystem)
            ->setLastDirSyncTime($lastDirSyncTime)
            ->setLicenses($licenses)
            ->setManagedBy($managedBy)
            ->setObjectId($objectId)
            ->setProxyAddresses($proxyAddresses)
            ->setValidationStatus($validationStatus);
    }
    /**
     * Get AssignedLicenses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAssignedLicense|null
     */
    public function getAssignedLicenses()
    {
        return isset($this->AssignedLicenses) ? $this->AssignedLicenses : null;
    }
    /**
     * Set AssignedLicenses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAssignedLicense $assignedLicenses
     * @return \StructType\Group
     */
    public function setAssignedLicenses(\ArrayType\ArrayOfAssignedLicense $assignedLicenses = null)
    {
        if (is_null($assignedLicenses) || (is_array($assignedLicenses) && empty($assignedLicenses))) {
            unset($this->AssignedLicenses);
        } else {
            $this->AssignedLicenses = $assignedLicenses;
        }
        return $this;
    }
    /**
     * Get CommonName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommonName()
    {
        return isset($this->CommonName) ? $this->CommonName : null;
    }
    /**
     * Set CommonName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commonName
     * @return \StructType\Group
     */
    public function setCommonName($commonName = null)
    {
        // validation for constraint: string
        if (!is_null($commonName) && !is_string($commonName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commonName)), __LINE__);
        }
        if (is_null($commonName) || (is_array($commonName) && empty($commonName))) {
            unset($this->CommonName);
        } else {
            $this->CommonName = $commonName;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\Group
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DirSyncProvisioningErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDirSyncProvisioningError|null
     */
    public function getDirSyncProvisioningErrors()
    {
        return isset($this->DirSyncProvisioningErrors) ? $this->DirSyncProvisioningErrors : null;
    }
    /**
     * Set DirSyncProvisioningErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDirSyncProvisioningError $dirSyncProvisioningErrors
     * @return \StructType\Group
     */
    public function setDirSyncProvisioningErrors(\ArrayType\ArrayOfDirSyncProvisioningError $dirSyncProvisioningErrors = null)
    {
        if (is_null($dirSyncProvisioningErrors) || (is_array($dirSyncProvisioningErrors) && empty($dirSyncProvisioningErrors))) {
            unset($this->DirSyncProvisioningErrors);
        } else {
            $this->DirSyncProvisioningErrors = $dirSyncProvisioningErrors;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \StructType\Group
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get EmailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAddress()
    {
        return isset($this->EmailAddress) ? $this->EmailAddress : null;
    }
    /**
     * Set EmailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAddress
     * @return \StructType\Group
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        if (is_null($emailAddress) || (is_array($emailAddress) && empty($emailAddress))) {
            unset($this->EmailAddress);
        } else {
            $this->EmailAddress = $emailAddress;
        }
        return $this;
    }
    /**
     * Get Errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfValidationError|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * Set Errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfValidationError $errors
     * @return \StructType\Group
     */
    public function setErrors(\ArrayType\ArrayOfValidationError $errors = null)
    {
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get GroupLicenseProcessingDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GroupLicenseProcessingDetail|null
     */
    public function getGroupLicenseProcessingDetail()
    {
        return isset($this->GroupLicenseProcessingDetail) ? $this->GroupLicenseProcessingDetail : null;
    }
    /**
     * Set GroupLicenseProcessingDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GroupLicenseProcessingDetail $groupLicenseProcessingDetail
     * @return \StructType\Group
     */
    public function setGroupLicenseProcessingDetail(\StructType\GroupLicenseProcessingDetail $groupLicenseProcessingDetail = null)
    {
        if (is_null($groupLicenseProcessingDetail) || (is_array($groupLicenseProcessingDetail) && empty($groupLicenseProcessingDetail))) {
            unset($this->GroupLicenseProcessingDetail);
        } else {
            $this->GroupLicenseProcessingDetail = $groupLicenseProcessingDetail;
        }
        return $this;
    }
    /**
     * Get GroupType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupType()
    {
        return isset($this->GroupType) ? $this->GroupType : null;
    }
    /**
     * Set GroupType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\GroupType::valueIsValid()
     * @uses \EnumType\GroupType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $groupType
     * @return \StructType\Group
     */
    public function setGroupType($groupType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GroupType::valueIsValid($groupType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $groupType, implode(', ', \EnumType\GroupType::getValidValues())), __LINE__);
        }
        if (is_null($groupType) || (is_array($groupType) && empty($groupType))) {
            unset($this->GroupType);
        } else {
            $this->GroupType = $groupType;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \StructType\Group
     */
    public function setIsSystem($isSystem = null)
    {
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get LastDirSyncTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastDirSyncTime()
    {
        return isset($this->LastDirSyncTime) ? $this->LastDirSyncTime : null;
    }
    /**
     * Set LastDirSyncTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastDirSyncTime
     * @return \StructType\Group
     */
    public function setLastDirSyncTime($lastDirSyncTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastDirSyncTime) && !is_string($lastDirSyncTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastDirSyncTime)), __LINE__);
        }
        if (is_null($lastDirSyncTime) || (is_array($lastDirSyncTime) && empty($lastDirSyncTime))) {
            unset($this->LastDirSyncTime);
        } else {
            $this->LastDirSyncTime = $lastDirSyncTime;
        }
        return $this;
    }
    /**
     * Get Licenses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAccountSkuIdentifier|null
     */
    public function getLicenses()
    {
        return isset($this->Licenses) ? $this->Licenses : null;
    }
    /**
     * Set Licenses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAccountSkuIdentifier $licenses
     * @return \StructType\Group
     */
    public function setLicenses(\ArrayType\ArrayOfAccountSkuIdentifier $licenses = null)
    {
        if (is_null($licenses) || (is_array($licenses) && empty($licenses))) {
            unset($this->Licenses);
        } else {
            $this->Licenses = $licenses;
        }
        return $this;
    }
    /**
     * Get ManagedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getManagedBy()
    {
        return isset($this->ManagedBy) ? $this->ManagedBy : null;
    }
    /**
     * Set ManagedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $managedBy
     * @return \StructType\Group
     */
    public function setManagedBy($managedBy = null)
    {
        // validation for constraint: string
        if (!is_null($managedBy) && !is_string($managedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($managedBy)), __LINE__);
        }
        if (is_null($managedBy) || (is_array($managedBy) && empty($managedBy))) {
            unset($this->ManagedBy);
        } else {
            $this->ManagedBy = $managedBy;
        }
        return $this;
    }
    /**
     * Get ObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObjectId()
    {
        return isset($this->ObjectId) ? $this->ObjectId : null;
    }
    /**
     * Set ObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $objectId
     * @return \StructType\Group
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($objectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($objectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectId)), __LINE__);
        }
        if (is_null($objectId) || (is_array($objectId) && empty($objectId))) {
            unset($this->ObjectId);
        } else {
            $this->ObjectId = $objectId;
        }
        return $this;
    }
    /**
     * Get ProxyAddresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getProxyAddresses()
    {
        return isset($this->ProxyAddresses) ? $this->ProxyAddresses : null;
    }
    /**
     * Set ProxyAddresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $proxyAddresses
     * @return \StructType\Group
     */
    public function setProxyAddresses(\ArrayType\ArrayOfstring $proxyAddresses = null)
    {
        if (is_null($proxyAddresses) || (is_array($proxyAddresses) && empty($proxyAddresses))) {
            unset($this->ProxyAddresses);
        } else {
            $this->ProxyAddresses = $proxyAddresses;
        }
        return $this;
    }
    /**
     * Get ValidationStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidationStatus()
    {
        return isset($this->ValidationStatus) ? $this->ValidationStatus : null;
    }
    /**
     * Set ValidationStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ValidationStatus::valueIsValid()
     * @uses \EnumType\ValidationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $validationStatus
     * @return \StructType\Group
     */
    public function setValidationStatus($validationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ValidationStatus::valueIsValid($validationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $validationStatus, implode(', ', \EnumType\ValidationStatus::getValidValues())), __LINE__);
        }
        if (is_null($validationStatus) || (is_array($validationStatus) && empty($validationStatus))) {
            unset($this->ValidationStatus);
        } else {
            $this->ValidationStatus = $validationStatus;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Group
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
