<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DomainDnsRecord StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DomainDnsRecord
 * @subpackage Structs
 */
class DomainDnsRecord extends AbstractStructBase
{
    /**
     * The Capability
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Capability;
    /**
     * The IsOptional
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOptional;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Label;
    /**
     * The ObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObjectId;
    /**
     * The Ttl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ttl;
    /**
     * Constructor method for DomainDnsRecord
     * @uses DomainDnsRecord::setCapability()
     * @uses DomainDnsRecord::setIsOptional()
     * @uses DomainDnsRecord::setLabel()
     * @uses DomainDnsRecord::setObjectId()
     * @uses DomainDnsRecord::setTtl()
     * @param string $capability
     * @param bool $isOptional
     * @param string $label
     * @param string $objectId
     * @param int $ttl
     */
    public function __construct($capability = null, $isOptional = null, $label = null, $objectId = null, $ttl = null)
    {
        $this
            ->setCapability($capability)
            ->setIsOptional($isOptional)
            ->setLabel($label)
            ->setObjectId($objectId)
            ->setTtl($ttl);
    }
    /**
     * Get Capability value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCapability()
    {
        return isset($this->Capability) ? $this->Capability : null;
    }
    /**
     * Set Capability value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DomainCapabilities::valueIsValid()
     * @uses \EnumType\DomainCapabilities::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $capability
     * @return \StructType\DomainDnsRecord
     */
    public function setCapability($capability = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DomainCapabilities::valueIsValid($capability)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $capability, implode(', ', \EnumType\DomainCapabilities::getValidValues())), __LINE__);
        }
        if (is_null($capability) || (is_array($capability) && empty($capability))) {
            unset($this->Capability);
        } else {
            $this->Capability = $capability;
        }
        return $this;
    }
    /**
     * Get IsOptional value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOptional()
    {
        return isset($this->IsOptional) ? $this->IsOptional : null;
    }
    /**
     * Set IsOptional value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOptional
     * @return \StructType\DomainDnsRecord
     */
    public function setIsOptional($isOptional = null)
    {
        if (is_null($isOptional) || (is_array($isOptional) && empty($isOptional))) {
            unset($this->IsOptional);
        } else {
            $this->IsOptional = $isOptional;
        }
        return $this;
    }
    /**
     * Get Label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->Label) ? $this->Label : null;
    }
    /**
     * Set Label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \StructType\DomainDnsRecord
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->Label);
        } else {
            $this->Label = $label;
        }
        return $this;
    }
    /**
     * Get ObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObjectId()
    {
        return isset($this->ObjectId) ? $this->ObjectId : null;
    }
    /**
     * Set ObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $objectId
     * @return \StructType\DomainDnsRecord
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($objectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($objectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($objectId) && !is_string($objectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectId)), __LINE__);
        }
        if (is_null($objectId) || (is_array($objectId) && empty($objectId))) {
            unset($this->ObjectId);
        } else {
            $this->ObjectId = $objectId;
        }
        return $this;
    }
    /**
     * Get Ttl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTtl()
    {
        return isset($this->Ttl) ? $this->Ttl : null;
    }
    /**
     * Set Ttl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ttl
     * @return \StructType\DomainDnsRecord
     */
    public function setTtl($ttl = null)
    {
        // validation for constraint: int
        if (!is_null($ttl) && !is_numeric($ttl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ttl)), __LINE__);
        }
        if (is_null($ttl) || (is_array($ttl) && empty($ttl))) {
            unset($this->Ttl);
        } else {
            $this->Ttl = $ttl;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DomainDnsRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
