<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Context StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Context
 * @subpackage Structs
 */
class Context extends AbstractStructBase
{
    /**
     * The DataBlob
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataBlob;
    /**
     * Constructor method for Context
     * @uses Context::setDataBlob()
     * @param string $dataBlob
     */
    public function __construct($dataBlob = null)
    {
        $this
            ->setDataBlob($dataBlob);
    }
    /**
     * Get DataBlob value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataBlob()
    {
        return isset($this->DataBlob) ? $this->DataBlob : null;
    }
    /**
     * Set DataBlob value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataBlob
     * @return \StructType\Context
     */
    public function setDataBlob($dataBlob = null)
    {
        // validation for constraint: string
        if (!is_null($dataBlob) && !is_string($dataBlob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataBlob)), __LINE__);
        }
        if (is_null($dataBlob) || (is_array($dataBlob) && empty($dataBlob))) {
            unset($this->DataBlob);
        } else {
            $this->DataBlob = $dataBlob;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Context
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
