<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddRoleScopedMembersRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AddRoleScopedMembersRequest
 * @subpackage Structs
 */
class AddRoleScopedMembersRequest extends Request
{
    /**
     * The AdministrativeUnitObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AdministrativeUnitObjectId;
    /**
     * The RoleMembers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRoleScopedMember
     */
    public $RoleMembers;
    /**
     * The RoleObjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoleObjectId;
    /**
     * Constructor method for AddRoleScopedMembersRequest
     * @uses AddRoleScopedMembersRequest::setAdministrativeUnitObjectId()
     * @uses AddRoleScopedMembersRequest::setRoleMembers()
     * @uses AddRoleScopedMembersRequest::setRoleObjectId()
     * @param string $administrativeUnitObjectId
     * @param \ArrayType\ArrayOfRoleScopedMember $roleMembers
     * @param string $roleObjectId
     */
    public function __construct($administrativeUnitObjectId = null, \ArrayType\ArrayOfRoleScopedMember $roleMembers = null, $roleObjectId = null)
    {
        $this
            ->setAdministrativeUnitObjectId($administrativeUnitObjectId)
            ->setRoleMembers($roleMembers)
            ->setRoleObjectId($roleObjectId);
    }
    /**
     * Get AdministrativeUnitObjectId value
     * @return string|null
     */
    public function getAdministrativeUnitObjectId()
    {
        return $this->AdministrativeUnitObjectId;
    }
    /**
     * Set AdministrativeUnitObjectId value
     * @param string $administrativeUnitObjectId
     * @return \StructType\AddRoleScopedMembersRequest
     */
    public function setAdministrativeUnitObjectId($administrativeUnitObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($administrativeUnitObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $administrativeUnitObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($administrativeUnitObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($administrativeUnitObjectId) && !is_string($administrativeUnitObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($administrativeUnitObjectId)), __LINE__);
        }
        $this->AdministrativeUnitObjectId = $administrativeUnitObjectId;
        return $this;
    }
    /**
     * Get RoleMembers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRoleScopedMember|null
     */
    public function getRoleMembers()
    {
        return isset($this->RoleMembers) ? $this->RoleMembers : null;
    }
    /**
     * Set RoleMembers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRoleScopedMember $roleMembers
     * @return \StructType\AddRoleScopedMembersRequest
     */
    public function setRoleMembers(\ArrayType\ArrayOfRoleScopedMember $roleMembers = null)
    {
        if (is_null($roleMembers) || (is_array($roleMembers) && empty($roleMembers))) {
            unset($this->RoleMembers);
        } else {
            $this->RoleMembers = $roleMembers;
        }
        return $this;
    }
    /**
     * Get RoleObjectId value
     * @return string|null
     */
    public function getRoleObjectId()
    {
        return $this->RoleObjectId;
    }
    /**
     * Set RoleObjectId value
     * @param string $roleObjectId
     * @return \StructType\AddRoleScopedMembersRequest
     */
    public function setRoleObjectId($roleObjectId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($roleObjectId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $roleObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($roleObjectId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($roleObjectId) && !is_string($roleObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roleObjectId)), __LINE__);
        }
        $this->RoleObjectId = $roleObjectId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddRoleScopedMembersRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
