<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetAdministrativeUnit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetAdministrativeUnit $parameters
     * @return \StructType\SetAdministrativeUnitResponse|bool
     */
    public function SetAdministrativeUnit(\StructType\SetAdministrativeUnit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetAdministrativeUnit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetPartnerInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetPartnerInformation $parameters
     * @return \StructType\SetPartnerInformationResponse|bool
     */
    public function SetPartnerInformation(\StructType\SetPartnerInformation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetPartnerInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCompanyContactInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCompanyContactInformation $parameters
     * @return \StructType\SetCompanyContactInformationResponse|bool
     */
    public function SetCompanyContactInformation(\StructType\SetCompanyContactInformation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetCompanyContactInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * SetCompanySecurityComplianceContactInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCompanySecurityComplianceContactInformation $parameters
     * @return \StructType\SetCompanySecurityComplianceContactInformationResponse|bool
     */
    public function SetCompanySecurityComplianceContactInformation(\StructType\SetCompanySecurityComplianceContactInformation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetCompanySecurityComplianceContactInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCompanyDirSyncEnabled
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCompanyDirSyncEnabled $parameters
     * @return \StructType\SetCompanyDirSyncEnabledResponse|bool
     */
    public function SetCompanyDirSyncEnabled(\StructType\SetCompanyDirSyncEnabled $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetCompanyDirSyncEnabled($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetAccidentalDeletionThreshold
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetAccidentalDeletionThreshold $parameters
     * @return \StructType\SetAccidentalDeletionThresholdResponse|bool
     */
    public function SetAccidentalDeletionThreshold(\StructType\SetAccidentalDeletionThreshold $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetAccidentalDeletionThreshold($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCompanyDirSyncFeature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCompanyDirSyncFeature $parameters
     * @return \StructType\SetCompanyDirSyncFeatureResponse|bool
     */
    public function SetCompanyDirSyncFeature(\StructType\SetCompanyDirSyncFeature $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetCompanyDirSyncFeature($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCompanyPasswordSyncEnabled
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCompanyPasswordSyncEnabled $parameters
     * @return \StructType\SetCompanyPasswordSyncEnabledResponse|bool
     */
    public function SetCompanyPasswordSyncEnabled(\StructType\SetCompanyPasswordSyncEnabled $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetCompanyPasswordSyncEnabled($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCompanySettings
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCompanySettings $parameters
     * @return \StructType\SetCompanySettingsResponse|bool
     */
    public function SetCompanySettings(\StructType\SetCompanySettings $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetCompanySettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetPasswordPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetPasswordPolicy $parameters
     * @return \StructType\SetPasswordPolicyResponse|bool
     */
    public function SetPasswordPolicy(\StructType\SetPasswordPolicy $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetPasswordPolicy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCompanyMultiNationalEnabled
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCompanyMultiNationalEnabled $parameters
     * @return \StructType\SetCompanyMultiNationalEnabledResponse|bool
     */
    public function SetCompanyMultiNationalEnabled(\StructType\SetCompanyMultiNationalEnabled $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetCompanyMultiNationalEnabled($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCompanyAllowedDataLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCompanyAllowedDataLocation $parameters
     * @return \StructType\SetCompanyAllowedDataLocationResponse|bool
     */
    public function SetCompanyAllowedDataLocation(\StructType\SetCompanyAllowedDataLocation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetCompanyAllowedDataLocation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetDomain $parameters
     * @return \StructType\SetDomainResponse|bool
     */
    public function SetDomain(\StructType\SetDomain $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetDomain($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetDomainAuthentication
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetDomainAuthentication $parameters
     * @return \StructType\SetDomainAuthenticationResponse|bool
     */
    public function SetDomainAuthentication(\StructType\SetDomainAuthentication $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetDomainAuthentication($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetDomainFederationSettings
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetDomainFederationSettings $parameters
     * @return \StructType\SetDomainFederationSettingsResponse|bool
     */
    public function SetDomainFederationSettings(\StructType\SetDomainFederationSettings $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetDomainFederationSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetGroup $parameters
     * @return \StructType\SetGroupResponse|bool
     */
    public function SetGroup(\StructType\SetGroup $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetUser $parameters
     * @return \StructType\SetUserResponse|bool
     */
    public function SetUser(\StructType\SetUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetUserLicenses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetUserLicenses $parameters
     * @return \StructType\SetUserLicensesResponse|bool
     */
    public function SetUserLicenses(\StructType\SetUserLicenses $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetUserLicenses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetUserLicensesByUpn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetUserLicensesByUpn $parameters
     * @return \StructType\SetUserLicensesByUpnResponse|bool
     */
    public function SetUserLicensesByUpn(\StructType\SetUserLicensesByUpn $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetUserLicensesByUpn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetServicePrincipal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetServicePrincipal $parameters
     * @return \StructType\SetServicePrincipalResponse|bool
     */
    public function SetServicePrincipal(\StructType\SetServicePrincipal $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetServicePrincipal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SetAccidentalDeletionThresholdResponse|\StructType\SetAdministrativeUnitResponse|\StructType\SetCompanyAllowedDataLocationResponse|\StructType\SetCompanyContactInformationResponse|\StructType\SetCompanyDirSyncEnabledResponse|\StructType\SetCompanyDirSyncFeatureResponse|\StructType\SetCompanyMultiNationalEnabledResponse|\StructType\SetCompanyPasswordSyncEnabledResponse|\StructType\SetCompanySecurityComplianceContactInformationResponse|\StructType\SetCompanySettingsResponse|\StructType\SetDomainAuthenticationResponse|\StructType\SetDomainFederationSettingsResponse|\StructType\SetDomainResponse|\StructType\SetGroupResponse|\StructType\SetPartnerInformationResponse|\StructType\SetPasswordPolicyResponse|\StructType\SetServicePrincipalResponse|\StructType\SetUserLicensesByUpnResponse|\StructType\SetUserLicensesResponse|\StructType\SetUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
