<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Msol ServiceType
 * @subpackage Services
 */
class Msol extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MsolConnect
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MsolConnect $parameters
     * @return \StructType\MsolConnectResponse|bool
     */
    public function MsolConnect(\StructType\MsolConnect $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MsolConnect($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MsolConnectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
