<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddAdministrativeUnit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddAdministrativeUnit $parameters
     * @return \StructType\AddAdministrativeUnitResponse|bool
     */
    public function AddAdministrativeUnit(\StructType\AddAdministrativeUnit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddAdministrativeUnit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddAdministrativeUnitMembers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddAdministrativeUnitMembers $parameters
     * @return \StructType\AddAdministrativeUnitMembersResponse|bool
     */
    public function AddAdministrativeUnitMembers(\StructType\AddAdministrativeUnitMembers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddAdministrativeUnitMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDomain $parameters
     * @return \StructType\AddDomainResponse|bool
     */
    public function AddDomain(\StructType\AddDomain $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddDomain($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddGroup $parameters
     * @return \StructType\AddGroupResponse|bool
     */
    public function AddGroup(\StructType\AddGroup $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddWellKnownGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddWellKnownGroup $parameters
     * @return \StructType\AddWellKnownGroupResponse|bool
     */
    public function AddWellKnownGroup(\StructType\AddWellKnownGroup $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddWellKnownGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddGroupMembers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddGroupMembers $parameters
     * @return \StructType\AddGroupMembersResponse|bool
     */
    public function AddGroupMembers(\StructType\AddGroupMembers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddGroupMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddRoleMembers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddRoleMembers $parameters
     * @return \StructType\AddRoleMembersResponse|bool
     */
    public function AddRoleMembers(\StructType\AddRoleMembers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddRoleMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddRoleMembersByRoleName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddRoleMembersByRoleName $parameters
     * @return \StructType\AddRoleMembersByRoleNameResponse|bool
     */
    public function AddRoleMembersByRoleName(\StructType\AddRoleMembersByRoleName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddRoleMembersByRoleName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddForeignGroupToRole
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddForeignGroupToRole $parameters
     * @return \StructType\AddForeignGroupToRoleResponse|bool
     */
    public function AddForeignGroupToRole(\StructType\AddForeignGroupToRole $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddForeignGroupToRole($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddRoleScopedMembers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddRoleScopedMembers $parameters
     * @return \StructType\AddRoleScopedMembersResponse|bool
     */
    public function AddRoleScopedMembers(\StructType\AddRoleScopedMembers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddRoleScopedMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddUser $parameters
     * @return \StructType\AddUserResponse|bool
     */
    public function AddUser(\StructType\AddUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddServicePrincipal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddServicePrincipal $parameters
     * @return \StructType\AddServicePrincipalResponse|bool
     */
    public function AddServicePrincipal(\StructType\AddServicePrincipal $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddServicePrincipal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddServicePrincipalCredentials
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddServicePrincipalCredentials $parameters
     * @return \StructType\AddServicePrincipalCredentialsResponse|bool
     */
    public function AddServicePrincipalCredentials(\StructType\AddServicePrincipalCredentials $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddServicePrincipalCredentials($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * AddServicePrincipalCredentialsBySpn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddServicePrincipalCredentialsBySpn $parameters
     * @return \StructType\AddServicePrincipalCredentialsBySpnResponse|bool
     */
    public function AddServicePrincipalCredentialsBySpn(\StructType\AddServicePrincipalCredentialsBySpn $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddServicePrincipalCredentialsBySpn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * AddServicePrincipalCredentialsByAppPrincipalId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddServicePrincipalCredentialsByAppPrincipalId $parameters
     * @return \StructType\AddServicePrincipalCredentialsByAppPrincipalIdResponse|bool
     */
    public function AddServicePrincipalCredentialsByAppPrincipalId(\StructType\AddServicePrincipalCredentialsByAppPrincipalId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddServicePrincipalCredentialsByAppPrincipalId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddAdministrativeUnitMembersResponse|\StructType\AddAdministrativeUnitResponse|\StructType\AddDomainResponse|\StructType\AddForeignGroupToRoleResponse|\StructType\AddGroupMembersResponse|\StructType\AddGroupResponse|\StructType\AddRoleMembersByRoleNameResponse|\StructType\AddRoleMembersResponse|\StructType\AddRoleScopedMembersResponse|\StructType\AddServicePrincipalCredentialsByAppPrincipalIdResponse|\StructType\AddServicePrincipalCredentialsBySpnResponse|\StructType\AddServicePrincipalCredentialsResponse|\StructType\AddServicePrincipalResponse|\StructType\AddUserResponse|\StructType\AddWellKnownGroupResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
