<?php

namespace EnumType;

/**
 * This class stands for SubscriptionStatus EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SubscriptionStatus
 * @subpackage Enumerations
 */
class SubscriptionStatus
{
    /**
     * Constant for value 'Enabled'
     * @return string 'Enabled'
     */
    const VALUE_ENABLED = 'Enabled';
    /**
     * Constant for value 'Warning'
     * @return string 'Warning'
     */
    const VALUE_WARNING = 'Warning';
    /**
     * Constant for value 'Suspended'
     * @return string 'Suspended'
     */
    const VALUE_SUSPENDED = 'Suspended';
    /**
     * Constant for value 'Deleted'
     * @return string 'Deleted'
     */
    const VALUE_DELETED = 'Deleted';
    /**
     * Constant for value 'LockedOut'
     * @return string 'LockedOut'
     */
    const VALUE_LOCKED_OUT = 'LockedOut';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ENABLED
     * @uses self::VALUE_WARNING
     * @uses self::VALUE_SUSPENDED
     * @uses self::VALUE_DELETED
     * @uses self::VALUE_LOCKED_OUT
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENABLED,
            self::VALUE_WARNING,
            self::VALUE_SUSPENDED,
            self::VALUE_DELETED,
            self::VALUE_LOCKED_OUT,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
