<?php

namespace EnumType;

/**
 * This class stands for ServicePrincipalCredentialType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ServicePrincipalCredentialType
 * @subpackage Enumerations
 */
class ServicePrincipalCredentialType
{
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'Asymmetric'
     * @return string 'Asymmetric'
     */
    const VALUE_ASYMMETRIC = 'Asymmetric';
    /**
     * Constant for value 'Symmetric'
     * @return string 'Symmetric'
     */
    const VALUE_SYMMETRIC = 'Symmetric';
    /**
     * Constant for value 'Password'
     * @return string 'Password'
     */
    const VALUE_PASSWORD = 'Password';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_ASYMMETRIC
     * @uses self::VALUE_SYMMETRIC
     * @uses self::VALUE_PASSWORD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OTHER,
            self::VALUE_ASYMMETRIC,
            self::VALUE_SYMMETRIC,
            self::VALUE_PASSWORD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
