<?php

namespace EnumType;

/**
 * This class stands for RoleMemberType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RoleMemberType
 * @subpackage Enumerations
 */
class RoleMemberType
{
    /**
     * Constant for value 'User'
     * @return string 'User'
     */
    const VALUE_USER = 'User';
    /**
     * Constant for value 'Group'
     * @return string 'Group'
     */
    const VALUE_GROUP = 'Group';
    /**
     * Constant for value 'ServicePrincipal'
     * @return string 'ServicePrincipal'
     */
    const VALUE_SERVICE_PRINCIPAL = 'ServicePrincipal';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_USER
     * @uses self::VALUE_GROUP
     * @uses self::VALUE_SERVICE_PRINCIPAL
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USER,
            self::VALUE_GROUP,
            self::VALUE_SERVICE_PRINCIPAL,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
