<?php

namespace EnumType;

/**
 * This class stands for Page EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Page
 * @subpackage Enumerations
 */
class Page
{
    /**
     * Constant for value 'First'
     * @return string 'First'
     */
    const VALUE_FIRST = 'First';
    /**
     * Constant for value 'Next'
     * @return string 'Next'
     */
    const VALUE_NEXT = 'Next';
    /**
     * Constant for value 'Previous'
     * @return string 'Previous'
     */
    const VALUE_PREVIOUS = 'Previous';
    /**
     * Constant for value 'Last'
     * @return string 'Last'
     */
    const VALUE_LAST = 'Last';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FIRST
     * @uses self::VALUE_NEXT
     * @uses self::VALUE_PREVIOUS
     * @uses self::VALUE_LAST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FIRST,
            self::VALUE_NEXT,
            self::VALUE_PREVIOUS,
            self::VALUE_LAST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
