<?php

namespace EnumType;

/**
 * This class stands for LicenseAssignmentStatusType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LicenseAssignmentStatusType
 * @subpackage Enumerations
 */
class LicenseAssignmentStatusType
{
    /**
     * Constant for value 'Active'
     * @return string 'Active'
     */
    const VALUE_ACTIVE = 'Active';
    /**
     * Constant for value 'ActiveWithError'
     * @return string 'ActiveWithError'
     */
    const VALUE_ACTIVE_WITH_ERROR = 'ActiveWithError';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_ACTIVE_WITH_ERROR
     * @uses self::VALUE_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVE,
            self::VALUE_ACTIVE_WITH_ERROR,
            self::VALUE_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
