<?php

namespace EnumType;

/**
 * This class stands for ForceTakeoverOption EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ForceTakeoverOption
 * @subpackage Enumerations
 */
class ForceTakeoverOption
{
    /**
     * Constant for value 'Fail'
     * @return string 'Fail'
     */
    const VALUE_FAIL = 'Fail';
    /**
     * Constant for value 'Force'
     * @return string 'Force'
     */
    const VALUE_FORCE = 'Force';
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FAIL
     * @uses self::VALUE_FORCE
     * @uses self::VALUE_DEFAULT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FAIL,
            self::VALUE_FORCE,
            self::VALUE_DEFAULT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
