<?php

namespace EnumType;

/**
 * This class stands for AdministrativeUnitMemberType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AdministrativeUnitMemberType
 * @subpackage Enumerations
 */
class AdministrativeUnitMemberType
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'User'
     * @return string 'User'
     */
    const VALUE_USER = 'User';
    /**
     * Constant for value 'Group'
     * @return string 'Group'
     */
    const VALUE_GROUP = 'Group';
    /**
     * Constant for value 'ServicePrincipal'
     * @return string 'ServicePrincipal'
     */
    const VALUE_SERVICE_PRINCIPAL = 'ServicePrincipal';
    /**
     * Constant for value 'Application'
     * @return string 'Application'
     */
    const VALUE_APPLICATION = 'Application';
    /**
     * Constant for value 'Device'
     * @return string 'Device'
     */
    const VALUE_DEVICE = 'Device';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_USER
     * @uses self::VALUE_GROUP
     * @uses self::VALUE_SERVICE_PRINCIPAL
     * @uses self::VALUE_APPLICATION
     * @uses self::VALUE_DEVICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_USER,
            self::VALUE_GROUP,
            self::VALUE_SERVICE_PRINCIPAL,
            self::VALUE_APPLICATION,
            self::VALUE_DEVICE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
