<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSubscription ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSubscription
 * @subpackage Arrays
 */
class ArrayOfSubscription extends AbstractStructArrayBase
{
    /**
     * The Subscription
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Subscription[]
     */
    public $Subscription;
    /**
     * Constructor method for ArrayOfSubscription
     * @uses ArrayOfSubscription::setSubscription()
     * @param \StructType\Subscription[] $subscription
     */
    public function __construct(array $subscription = array())
    {
        $this
            ->setSubscription($subscription);
    }
    /**
     * Get Subscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Subscription[]|null
     */
    public function getSubscription()
    {
        return isset($this->Subscription) ? $this->Subscription : null;
    }
    /**
     * Set Subscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Subscription[] $subscription
     * @return \ArrayType\ArrayOfSubscription
     */
    public function setSubscription(array $subscription = array())
    {
        foreach ($subscription as $arrayOfSubscriptionSubscriptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfSubscriptionSubscriptionItem instanceof \StructType\Subscription) {
                throw new \InvalidArgumentException(sprintf('The Subscription property can only contain items of \StructType\Subscription, "%s" given', is_object($arrayOfSubscriptionSubscriptionItem) ? get_class($arrayOfSubscriptionSubscriptionItem) : gettype($arrayOfSubscriptionSubscriptionItem)), __LINE__);
            }
        }
        if (is_null($subscription) || (is_array($subscription) && empty($subscription))) {
            unset($this->Subscription);
        } else {
            $this->Subscription = $subscription;
        }
        return $this;
    }
    /**
     * Add item to Subscription value
     * @throws \InvalidArgumentException
     * @param \StructType\Subscription $item
     * @return \ArrayType\ArrayOfSubscription
     */
    public function addToSubscription(\StructType\Subscription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Subscription) {
            throw new \InvalidArgumentException(sprintf('The Subscription property can only contain items of \StructType\Subscription, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Subscription[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Subscription|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Subscription|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Subscription|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Subscription|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Subscription|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Subscription
     */
    public function getAttributeName()
    {
        return 'Subscription';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSubscription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
