<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServiceEndpoint ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfServiceEndpoint
 * @subpackage Arrays
 */
class ArrayOfServiceEndpoint extends AbstractStructArrayBase
{
    /**
     * The ServiceEndpoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceEndpoint[]
     */
    public $ServiceEndpoint;
    /**
     * Constructor method for ArrayOfServiceEndpoint
     * @uses ArrayOfServiceEndpoint::setServiceEndpoint()
     * @param \StructType\ServiceEndpoint[] $serviceEndpoint
     */
    public function __construct(array $serviceEndpoint = array())
    {
        $this
            ->setServiceEndpoint($serviceEndpoint);
    }
    /**
     * Get ServiceEndpoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceEndpoint[]|null
     */
    public function getServiceEndpoint()
    {
        return isset($this->ServiceEndpoint) ? $this->ServiceEndpoint : null;
    }
    /**
     * Set ServiceEndpoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceEndpoint[] $serviceEndpoint
     * @return \ArrayType\ArrayOfServiceEndpoint
     */
    public function setServiceEndpoint(array $serviceEndpoint = array())
    {
        foreach ($serviceEndpoint as $arrayOfServiceEndpointServiceEndpointItem) {
            // validation for constraint: itemType
            if (!$arrayOfServiceEndpointServiceEndpointItem instanceof \StructType\ServiceEndpoint) {
                throw new \InvalidArgumentException(sprintf('The ServiceEndpoint property can only contain items of \StructType\ServiceEndpoint, "%s" given', is_object($arrayOfServiceEndpointServiceEndpointItem) ? get_class($arrayOfServiceEndpointServiceEndpointItem) : gettype($arrayOfServiceEndpointServiceEndpointItem)), __LINE__);
            }
        }
        if (is_null($serviceEndpoint) || (is_array($serviceEndpoint) && empty($serviceEndpoint))) {
            unset($this->ServiceEndpoint);
        } else {
            $this->ServiceEndpoint = $serviceEndpoint;
        }
        return $this;
    }
    /**
     * Add item to ServiceEndpoint value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceEndpoint $item
     * @return \ArrayType\ArrayOfServiceEndpoint
     */
    public function addToServiceEndpoint(\StructType\ServiceEndpoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceEndpoint) {
            throw new \InvalidArgumentException(sprintf('The ServiceEndpoint property can only contain items of \StructType\ServiceEndpoint, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServiceEndpoint[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ServiceEndpoint|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ServiceEndpoint|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ServiceEndpoint|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ServiceEndpoint|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ServiceEndpoint|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceEndpoint
     */
    public function getAttributeName()
    {
        return 'ServiceEndpoint';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfServiceEndpoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
