<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPartnerContract ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPartnerContract
 * @subpackage Arrays
 */
class ArrayOfPartnerContract extends AbstractStructArrayBase
{
    /**
     * The PartnerContract
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PartnerContract[]
     */
    public $PartnerContract;
    /**
     * Constructor method for ArrayOfPartnerContract
     * @uses ArrayOfPartnerContract::setPartnerContract()
     * @param \StructType\PartnerContract[] $partnerContract
     */
    public function __construct(array $partnerContract = array())
    {
        $this
            ->setPartnerContract($partnerContract);
    }
    /**
     * Get PartnerContract value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PartnerContract[]|null
     */
    public function getPartnerContract()
    {
        return isset($this->PartnerContract) ? $this->PartnerContract : null;
    }
    /**
     * Set PartnerContract value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PartnerContract[] $partnerContract
     * @return \ArrayType\ArrayOfPartnerContract
     */
    public function setPartnerContract(array $partnerContract = array())
    {
        foreach ($partnerContract as $arrayOfPartnerContractPartnerContractItem) {
            // validation for constraint: itemType
            if (!$arrayOfPartnerContractPartnerContractItem instanceof \StructType\PartnerContract) {
                throw new \InvalidArgumentException(sprintf('The PartnerContract property can only contain items of \StructType\PartnerContract, "%s" given', is_object($arrayOfPartnerContractPartnerContractItem) ? get_class($arrayOfPartnerContractPartnerContractItem) : gettype($arrayOfPartnerContractPartnerContractItem)), __LINE__);
            }
        }
        if (is_null($partnerContract) || (is_array($partnerContract) && empty($partnerContract))) {
            unset($this->PartnerContract);
        } else {
            $this->PartnerContract = $partnerContract;
        }
        return $this;
    }
    /**
     * Add item to PartnerContract value
     * @throws \InvalidArgumentException
     * @param \StructType\PartnerContract $item
     * @return \ArrayType\ArrayOfPartnerContract
     */
    public function addToPartnerContract(\StructType\PartnerContract $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PartnerContract) {
            throw new \InvalidArgumentException(sprintf('The PartnerContract property can only contain items of \StructType\PartnerContract, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PartnerContract[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PartnerContract|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PartnerContract|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PartnerContract|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PartnerContract|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PartnerContract|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PartnerContract
     */
    public function getAttributeName()
    {
        return 'PartnerContract';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPartnerContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
