<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TenantNotPartnerTypeException StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TenantNotPartnerTypeException
 * @subpackage Structs
 */
class TenantNotPartnerTypeException extends InvalidParameterException
{
    /**
     * The PartnerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PartnerId;
    /**
     * Constructor method for TenantNotPartnerTypeException
     * @uses TenantNotPartnerTypeException::setPartnerId()
     * @param string $partnerId
     */
    public function __construct($partnerId = null)
    {
        $this
            ->setPartnerId($partnerId);
    }
    /**
     * Get PartnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartnerId()
    {
        return isset($this->PartnerId) ? $this->PartnerId : null;
    }
    /**
     * Set PartnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partnerId
     * @return \StructType\TenantNotPartnerTypeException
     */
    public function setPartnerId($partnerId = null)
    {
        // validation for constraint: string
        if (!is_null($partnerId) && !is_string($partnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partnerId)), __LINE__);
        }
        if (is_null($partnerId) || (is_array($partnerId) && empty($partnerId))) {
            unset($this->PartnerId);
        } else {
            $this->PartnerId = $partnerId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TenantNotPartnerTypeException
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
