<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveServicePrincipalCredentialsByAppPrincipalIdRequest
 * StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RemoveServicePrincipalCredentialsByAppPrincipalIdRequest
 * @subpackage Structs
 */
class RemoveServicePrincipalCredentialsByAppPrincipalIdRequest extends Request
{
    /**
     * The AppPrincipalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppPrincipalId;
    /**
     * The KeyIds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfguid
     */
    public $KeyIds;
    /**
     * The MsodsAsKeyStore
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MsodsAsKeyStore;
    /**
     * Constructor method for RemoveServicePrincipalCredentialsByAppPrincipalIdRequest
     * @uses RemoveServicePrincipalCredentialsByAppPrincipalIdRequest::setAppPrincipalId()
     * @uses RemoveServicePrincipalCredentialsByAppPrincipalIdRequest::setKeyIds()
     * @uses RemoveServicePrincipalCredentialsByAppPrincipalIdRequest::setMsodsAsKeyStore()
     * @param string $appPrincipalId
     * @param \ArrayType\ArrayOfguid $keyIds
     * @param bool $msodsAsKeyStore
     */
    public function __construct($appPrincipalId = null, \ArrayType\ArrayOfguid $keyIds = null, $msodsAsKeyStore = null)
    {
        $this
            ->setAppPrincipalId($appPrincipalId)
            ->setKeyIds($keyIds)
            ->setMsodsAsKeyStore($msodsAsKeyStore);
    }
    /**
     * Get AppPrincipalId value
     * @return string|null
     */
    public function getAppPrincipalId()
    {
        return $this->AppPrincipalId;
    }
    /**
     * Set AppPrincipalId value
     * @param string $appPrincipalId
     * @return \StructType\RemoveServicePrincipalCredentialsByAppPrincipalIdRequest
     */
    public function setAppPrincipalId($appPrincipalId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($appPrincipalId) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $appPrincipalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($appPrincipalId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($appPrincipalId) && !is_string($appPrincipalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appPrincipalId)), __LINE__);
        }
        $this->AppPrincipalId = $appPrincipalId;
        return $this;
    }
    /**
     * Get KeyIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfguid|null
     */
    public function getKeyIds()
    {
        return isset($this->KeyIds) ? $this->KeyIds : null;
    }
    /**
     * Set KeyIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfguid $keyIds
     * @return \StructType\RemoveServicePrincipalCredentialsByAppPrincipalIdRequest
     */
    public function setKeyIds(\ArrayType\ArrayOfguid $keyIds = null)
    {
        if (is_null($keyIds) || (is_array($keyIds) && empty($keyIds))) {
            unset($this->KeyIds);
        } else {
            $this->KeyIds = $keyIds;
        }
        return $this;
    }
    /**
     * Get MsodsAsKeyStore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMsodsAsKeyStore()
    {
        return isset($this->MsodsAsKeyStore) ? $this->MsodsAsKeyStore : null;
    }
    /**
     * Set MsodsAsKeyStore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $msodsAsKeyStore
     * @return \StructType\RemoveServicePrincipalCredentialsByAppPrincipalIdRequest
     */
    public function setMsodsAsKeyStore($msodsAsKeyStore = null)
    {
        if (is_null($msodsAsKeyStore) || (is_array($msodsAsKeyStore) && empty($msodsAsKeyStore))) {
            unset($this->MsodsAsKeyStore);
        } else {
            $this->MsodsAsKeyStore = $msodsAsKeyStore;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveServicePrincipalCredentialsByAppPrincipalIdRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
