<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PasswordPolicy StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PasswordPolicy
 * @subpackage Structs
 */
class PasswordPolicy extends AbstractStructBase
{
    /**
     * The NotificationDays
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NotificationDays;
    /**
     * The ValidityPeriod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ValidityPeriod;
    /**
     * Constructor method for PasswordPolicy
     * @uses PasswordPolicy::setNotificationDays()
     * @uses PasswordPolicy::setValidityPeriod()
     * @param int $notificationDays
     * @param int $validityPeriod
     */
    public function __construct($notificationDays = null, $validityPeriod = null)
    {
        $this
            ->setNotificationDays($notificationDays)
            ->setValidityPeriod($validityPeriod);
    }
    /**
     * Get NotificationDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNotificationDays()
    {
        return isset($this->NotificationDays) ? $this->NotificationDays : null;
    }
    /**
     * Set NotificationDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $notificationDays
     * @return \StructType\PasswordPolicy
     */
    public function setNotificationDays($notificationDays = null)
    {
        // validation for constraint: int
        if (!is_null($notificationDays) && !is_numeric($notificationDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($notificationDays)), __LINE__);
        }
        if (is_null($notificationDays) || (is_array($notificationDays) && empty($notificationDays))) {
            unset($this->NotificationDays);
        } else {
            $this->NotificationDays = $notificationDays;
        }
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getValidityPeriod()
    {
        return isset($this->ValidityPeriod) ? $this->ValidityPeriod : null;
    }
    /**
     * Set ValidityPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $validityPeriod
     * @return \StructType\PasswordPolicy
     */
    public function setValidityPeriod($validityPeriod = null)
    {
        // validation for constraint: int
        if (!is_null($validityPeriod) && !is_numeric($validityPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($validityPeriod)), __LINE__);
        }
        if (is_null($validityPeriod) || (is_array($validityPeriod) && empty($validityPeriod))) {
            unset($this->ValidityPeriod);
        } else {
            $this->ValidityPeriod = $validityPeriod;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PasswordPolicy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
